<?php

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Models\Guest;
use App\Models\Reservation;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::namespace('api')->group(function () {
    Route::post('contact', 'ContactUsApiControllers@Contact');
    Route::get('/images', 'ImagesController@getRand');
    Route::get('/phone-images', 'ImagesController@phoneImage');
    Route::get('/allCountry', 'Air\DataSenderController@allCountry');
    Route::post('/register', 'AuthCountroller@register');
    Route::get('/guest', 'AuthCountroller@guest');
    Route::post('/guest', 'AuthCountroller@guest');
    // Route::get('/me', 'AuthCountroller@me');
    Route::post('/reset-password', 'AuthCountroller@resetPassword');
    Route::get('/reopt-password/{verification}', 'AuthCountroller@forgetPasswordReOTP');
    Route::post('/otp', 'AuthCountroller@obtCode');
    Route::post('/updatedPassword', 'AuthCountroller@updatedPassword');
    Route::post('/register_otp', 'AuthCountroller@regiestOTP');
    Route::get('/resend/{id}', 'AuthCountroller@resendOTP');
    Route::post('/updated', 'AuthCountroller@updatedUser');

    Route::get('/me', 'AuthCountroller@me')->middleware('CheckAuth');
    Route::prefix('history')->middleware('CheckAuth')->group(function () {
        Route::get('/hotel/{limit?}/{type?}', 'UsersHistory@hotel');
        Route::get('/air/{limit}', 'UsersHistory@air');
    });

    Route::get('/test', function () {
        return $urlRedirect = route('finished');
        // dd(Carbon::now(),Carbon::now()->addMinutes(18));
        $gues = Guest::find(1);
        // $gues->hotel_time = Carbon::now()->addMinutes(18);
        //$gues->save();


        $expiredTime = Carbon::parse($gues->hotel_time);
        $remainingMinutes = $expiredTime->diff(Carbon::now())->format('%I:%S');
        $remainingMinutes2 = (int)$expiredTime->diff(Carbon::now())->format('%I');
        return [
            'hotel_time' => $gues->hotel_time,
            'now' => Carbon::now()->toDateTimeString(),
            'remainingMinutes' => $remainingMinutes,
            '$remainingMinutes2' => $remainingMinutes2,
        ];
        $nowTime = Carbon::now()->addHours(2);
        $expiredTime = Carbon::parse($nowTime);
        dd($nowTime, $expiredTime);
        return $remainingMinutes = max($expiredTime->diffInMinutes(Carbon::now(), false), 0);
        $all = \App\Models\Reservation::all();

        foreach ($all as $a) {
            $guest = Guest::find($a->guest_id);
            $res = Reservation::find($a->id);
            $res->user_id = $guest->client_id;
            $res->save();
        }

        return 'done';

        //  $ip = request()->getClientIp();
        //    return response()->json(['ip' => $ip]);
    });

    Route::post('hotel/booking_detail', 'HotelSearchController@bookingDetail');
    Route::prefix('hotel')->middleware('checkGuest')->group(function () {
        Route::get('/', 'HotelSearchController@getCountry');
        Route::get('/city/{code}', 'HotelSearchController@getCity');
        Route::get('/hotel_city/{code}/{is_detailed}', 'HotelSearchController@HotelByCity');
        Route::get('/search', 'HotelSearchController@search');
        Route::post('/prebook', 'HotelSearchController@prebook');
       // Route::post('/booking-tbo', 'HotelSearchController@bookingBTO');
        Route::post('/cancel_tbo', 'HotelSearchController@cancel');
        // Route::post('/booking_detail', 'HotelSearchController@bookingDetail');
        Route::post('/HotelDetails', 'HotelSearchController@hotelDetails');
        Route::get('/checkbooking/{id}', 'HotelSearchController@checkingBooking')->name('checkingBooking');
    });
    Route::namespace('Air')->group(function () {
        Route::get('air/airports/{code}', 'DataSenderController@search');
        Route::post('air/GetBookingDetails', 'AirControllers@GetBookingDetails');
        Route::prefix('air')->middleware(['checkGuest', 'auth.tbo'])->group(function () {
            Route::post('search', 'AirControllers@search');
            Route::post('search/detials', 'AirControllers@searchDetials');
            Route::post('booking', 'AirControllers@booking');
           // Route::post('ticket/lcc', 'AirControllers@ticketLcc');
           // Route::post('ticket/no-lcc', 'AirControllers@ticketLcc');
            Route::get('/checkbookingAir/{id}', 'AirControllers@checkingBooking')->name('checkingBookingAir');
        });
    });

    Route::get(
        "/payment-webview/{payment_code}/{user_id}",
        "PaymentOrderController@getURL"
    )->name('payment-webview');


    /*
     Route::get(
         "/payment-webview/{payment_code}",
         "PaymentOrderController@getURL"
     )->name('payment-webview')->middleware(['checkGuest', 'auth.tbo']);
     */
    Route::post("/access-token", "PaymentOrderController@index")->name('access-token');
    Route::post("/pay", "PaymentOrderController@pay")->name('pay');
    //Route::post("/save-status", "PaymentOrderController@savePaymentStatus")->name('save-status');
    Route::post("/save-status", "HotelSearchController@PaymentStatus")->name('save-status');
    Route::post("/air-save-status", "Air\AirControllers@PaymentStatus")->name('ariSave-status');
    Route::get("/check-status/{id}", "PaymentOrderController@checkPaymentStatus")->name('check-status');
    Route::get("/payment_redirect", function () {
        return View('finished');
    })->name('finished');

    Route::prefix('hajj')->group(function () {
        Route::namespace('Hajj')->group(function () {
            Route::get("country/{type}", "HajjApiController@getCountryType");
            Route::get("city/{id}", "HajjApiController@getCitiesByCountry");
            Route::get("check-country/{id}", "HajjApiController@getPricesByNational");
            Route::get("download/file", "HajjApiController@downloadFile");
            // payment created and view and status
            Route::get("payment/get/link/{id}", "HajjApiController@payment");
            Route::get(
                "payment/{payment_code}/{user_id}",
                "HajjApiController@getURL"
            )->name('hajj_payment-webview');
            Route::get('/checkbooking/{id}', 'HajjApiController@checkingBooking')->name('hajj.checkingBooking');

            // ajax payment page
            Route::post("/access-token", "HajjApiController@accessToken")->name('hajj.access-token');
            Route::post("pay", "HajjApiController@pay")->name('hajj.pay');
            Route::post("/save-status", "HajjApiController@PaymentStatus")->name('hajj.save-status');


            Route::middleware('CheckAuth')->group(function () {
                Route::post("request", "HajjApiController@hajjRequest");
                Route::get("list", "HajjApiController@list");
                Route::get("details/{id}", "HajjApiController@getDetials");

            });
        });
    });
});


