<?php

namespace App\Sys\Services\Hajj;

use App\Models\Countries;
use App\Models\hajjPayment;
use App\PaymentAPI;
use App\Sys\Repository\hajjPaymentRepo;
use App\Sys\Repository\hajjRepo;
use App\Sys\Services;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;

class HajjServices extends Services
{
    use PaymentAPI;

    private $hajj;
    private $payment;

    public function __construct()
    {
        $this->hajj = new hajjRepo();
        $this->payment = new hajjPaymentRepo();
    }

    public function add($data)
    {
        // Validate the data

        $rules = [
            'national' => 'required|integer|exists:mysql2.countries,id',
            'country_id' => 'nullable|integer|exists:mysql2.countries,id',
            'country_code' => 'required',
            'type' => 'required|in:hajj,umrah',
            'city_id' => 'nullable|integer|exists:mysql2.cities,id',
            'phone' => 'required|numeric',
            'email' => 'nullable|email',
            'detials' => 'required|array|min:1',
            'detials.*.first_name_en' => 'required|string',
            'detials.*.first_name_ar' => 'required|string',
            'detials.*.birth_day' => 'required|integer|min:1|max:31',
            'detials.*.birth_month' => 'required|integer|min:1|max:12',
            'detials.*.birth_year' => 'required|integer|min:1900|max:' . date('Y'),
            'detials.*.passport_number' => 'required',
            'detials.*.passport_expire_day' => 'required|integer|min:1|max:31',
            'detials.*.passport_expire_month' => 'required|integer|min:1|max:12',
            'detials.*.passport_expire_year' => 'required|integer|min:' . date('Y'),
            'detials.*.photo' => ['required', 'string'],


        ];
        $validator = validator($data, $rules);
        $countrty = Countries::find($data['national']);
        $validator->after(function ($validator) use ($data, $countrty) {
            foreach ($data['detials'] as $index => $item) {
                /*
                if (isset($item['photo'])) {
                    // التأكد من أن الـ photo تبدأ بصيغة base64 صحيحة
                    if (!preg_match('/^data:image\/[a-zA-Z0-9]+;base64,/', $item['photo'], $match)) {
                        $validator->errors()->add("detials.$index.photo", 'The photo must be a valid base64 encoded image.');
                        continue;
                    }

                    $base64Str = substr($item['photo'], strpos($item['photo'], ',') + 1);

                    // استبدال أي مسافات بـ "+" لضمان توافق الـ base64
                    $base64Str = str_replace(' ', '+', $base64Str);

                    // جرب تفك الترميز
                    $decoded = base64_decode($base64Str, true);

                    // تأكد أن الصورة فعلاً اتفكت وبياناتها مش فاضية
                    if ($decoded === false || strlen($decoded) === 0) {
                        $validator->errors()->add("detials.$index.photo", 'The photo is invalid or not in base64 format.');
                        continue;
                    }

                    // حجم الصورة لا يتجاوز 2 ميجابايت
                    if (strlen($decoded) > 2 * 1024 * 1024) {
                        $validator->errors()->add("detials.$index.photo", 'The photo must not exceed 2MB.');
                    }
                }
                */

                if ($countrty && $countrty->id == 24 && $index == 0) {
                    if ($item['hosting_file'] == null) {
                        $validator->errors()->add("detials.$index.hosting_file", 'The hosting file is required for the first person when country is Sudan.');
                    }
                }
            }
        });

        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        $photoFolder = 'uploads/photos/';
        $fileFolder = 'uploads/files/';
        foreach ($data['detials'] as $index => $item) {
            // PHOTO
            if ($item['photo'] != null) {
                $photoDir = public_path($photoFolder);
                if (!file_exists($photoDir)) {
                    mkdir($photoDir, 0777, true); // إنشاء المجلدات بشكل متداخل
                }
                preg_match('/^data:image\/(\w+);base64,/', $item['photo'], $type);
                $photoExt = $type[1];
                $photoData = base64_decode(preg_replace('/^data:image\/\w+;base64,/', '', $item['photo']));

                $photoName = uniqid('photo_') . Str::random(10) . '.' . $photoExt;
                $photoPath = public_path($photoFolder . $photoName);
                file_put_contents($photoPath, $photoData);

                $data['detials'][$index]['photo_link'] = url($photoFolder . $photoName); // <== Full URL
            }

            // FILE
            if ($item['hosting_file'] != null) {
                $fileDir = public_path($fileFolder);
                if (!file_exists($fileDir)) {
                    mkdir($fileDir, 0777, true); // إنشاء المجلدات بشكل متداخل
                }
                preg_match('/^data:application\/(\w+);base64,/', $item['hosting_file'], $type);
                $fileExt = $type[1]; // pdf, zip, etc...
                $fileData = base64_decode(preg_replace('/^data:application\/\w+;base64,/', '', $item['hosting_file']));

                $fileName = uniqid('file_') . Str::random(10) . '.' . $fileExt;
                $filePath = public_path($fileFolder . $fileName);
                file_put_contents($filePath, $fileData);
                $data['detials'][$index]['hosting_link'] = url($fileFolder . $fileName); // <== Full URL
            }

        }
        $data['price_child'] = $countrty->{$data['type'] . '_price_adult'};
        $data['price_adult'] = $countrty->{$data['type'] . '_price_child'};
        return $this->hajj->add($data);

    }

    public function list()
    {
        return $this->hajj->list();
    }

    public function getDeitals($id)
    {
        return $this->hajj->getDeitals($id);
    }

    public function payment($id)
    {
        // get One
        $hajj = $this->hajj->getByid($id);
        if (
            $hajj->user_id == Auth()->guard('api')->user()->id &&
            $hajj->status == "waiting_for_payment" &&
            $hajj->date_exp >= Carbon::now()
        ) {
            $data = [
                'hajj_id' => $id,
                'currency_code' => 'AED',
                "value" => intval($hajj->total * 100)
            ];
            $createdPayment = $this->payment->add($data);
            $url = route('hajj_payment-webview', ['payment_code' => $createdPayment->id, 'user_id' => $createdPayment->user_id]);
            $checkStatus = route('hajj.checkingBooking', ['id' => $createdPayment->id]);
            return [
                "url" => $url,
                "payment_code" => $createdPayment->id,
                'check_status_url' => $checkStatus,
                'pramater_one' => $createdPayment->id,
                'pramater_two' => $createdPayment->user_id,
            ];

        }
        $this->setError('This request cannot be processed. It may have expired, already been paid, or does not belong to the current user.');
        return false;
    }

    public function checkPayment($id)
    {
        return $this->payment->getByid($id);
    }

    public function pay($request)
    {
        // get content
        $content = $request->getContent();
        $json = json_decode($content);
        $payment_code = $json->payment_code;
        $user = $json->the_code;
        $redirect_url = URL::route('finished');
        $payment = $this->payment->getByid($payment_code);
        if (!empty($payment)) {
            if ($payment->expires_at < now()) {
                $this->setError([
                    'status' => 419,
                    'message' => 'pay',
                    'error' => 'session expired'
                ]);
                return false;
            }
            if ($payment->user_id != $user) {
                $this->setError([
                    'status' => 403,
                    'message' => 'pay',
                    'error' => 'access denied'
                ]);
                return false;
            }

            $params = [
                "action" => $payment->action ?? "PURCHASE",
                "amount" => [
                    "currencyCode" => "AED", // $payment->currency_code ?? "AED",
                    "value" => $payment->value
                ],
                "language" => "en",
                "payment" => [
                    "currency" => "AED" //$payment->currency_code ?? "AED"
                ],
                "emailAddress" => $payment->getUser?->email ?? 'msayed0@outlook.com',
                "merchantAttributes" => [
                    "redirectUrl" => $redirect_url,
                    "cancelUrl" => $redirect_url,
                    "skip3DS" => false,
                    "skipConfirmationPage" => false
                ]
            ];

            try {
                $response = $this->PaymentAPI(
                    $params,
                    [
                        'Accept' => "application/vnd.ni-payment.v2+json",
                        'Content-type' => "application/vnd.ni-payment.v2+json",
                        'Authorization' => "Bearer " . $payment->payment_token,
                    ],
                    "transactions/outlets/" . config('services.third_party.outlet') . "/payment/hosted-session/" . $json->sessionID
                    , "post"
                );

                $pa = hajjPayment::find($payment_code);
                $pa->session_id = $json->sessionID;
                $pa->token = $json->token;
                $pa->pay_response = json_encode($response);
                $pa->save();

                return $response;
            } catch (\Throwable $th) {
                $this->setError([
                    'status' => $th->getCode() == 0 ? 500 : $th->getCode(),
                    'message' => 'pay',
                    'error' => $th->getMessage()
                ]);
                return false;
            }
        }
        $this->setError([
            'status' => 0,
            'message' => 'pay',
            'error' => 'not found payment'
        ]);
        return false;

    }

    public function getAuthToken($request)
    {
        $content = $request->getContent();
        $json = json_decode($content);
        $payment_code = $json->payment_code;
        $response = $this->PaymentAPI(
            ['grant_type' => 'client_credentials'],
            [
                "Content-Type" => "application/vnd.ni-identity.v1+json",
                "Authorization" => "Basic " . config("services.third_party.webhook")
            ], "identity/auth/access-token", "post"
        );

        if (isset($response['access_token']) && $response['access_token'] != null) {
            if ($generate = $this->payment->update($response, $payment_code, $response)) {
                return $generate;
            }
        }
        $this->setError([
            'status' => 400,
            'message' => 'access token',
            'errors' => 'order not found try again'
        ]);
        return false;

    }

    public function PaymentStatus($data)
    {
        $payment = $this->payment->getByid($data['payment_code']);
        if (!empty($payment)) {
            $orders = json_decode($payment->pay_response, true);
            $respo = $this->checkStatus($orders);
            $status = isset($respo['_embedded']['payment'][0]['state']) ? $respo['_embedded']['payment'][0]['state'] :$data['payment_status'];
            $payment->payment_status = $status;
            $payment->status = $status == "CAPTURED" ? "paid" : "payment_errors";
            $payment->save();
            if ($status == "CAPTURED") {
                $this->hajj->updateStatus($payment->hajj_id, 'paid');
                return ['status' => 200,
                    'message' => 'check status',
                    'payment_status' => $status];
            } else {
                $this->hajj->updateStatus($payment->hajj_id, 'payment_errors');
                $this->setError(['status' => 400,
                    'message' => 'check status',
                    'payment_status' => $status]);
                return false;
            }
        }

        $this->setError(['status' => 400,
            'message' => 'check status',
            'payment_status' => 'cansel']);
        return false;

    }


    public
    function checkStatus($orders)
    {
        $token = $this->getAccsessToken();
        $end = 'transactions/outlets/' . $orders['outletId'] . '/orders/' . $orders['orderReference'];
        $response = $this->PaymentAPI(null,
            [
                'Accept' => "application/vnd.ni-payment.v2+json",
                'Content-type' => "application/vnd.ni-payment.v2+json",
                'Authorization' => "Bearer " . $token,
            ],
            $end
            , "GET"
        );

        return $response;
    }

    public
    function getAccsessToken()
    {
        $response = $this->PaymentAPI(
            ['grant_type' => 'client_credentials'],
            [
                "Content-Type" => "application/vnd.ni-identity.v1+json",
                "Authorization" => "Basic " . config("services.third_party.webhook")
            ], "identity/auth/access-token", "post"
        );

        return $response['access_token'];
    }

    public function checkingBooking($id)
    {
        $payment = $this->payment->getByid($id);
        if(!empty($payment)){
            return[
                'payment_status'=>$payment->payment_status,
                'status'=>$payment->getHajj?->status,
                'last_updated'=>$payment->updated_at
            ];
        }
        return false;
    }


}
