<?php

namespace App\Sys\Repository;

use App\Models\hajjPayment;
use Carbon\Carbon;

class hajjPaymentRepo
{

    private $hajjPayment;

    public function __construct()
    {
        $this->hajjPayment = new hajjPayment();
    }

    public function add($data)
    {

        $this->hajjPayment->user_id = Auth()->guard('api')->user()->id;
        $this->hajjPayment->hajj_request_id = $data['hajj_id'];
        $this->hajjPayment->payment_token = $data['access_token'] ?? null;
        $this->hajjPayment->payment_token_type = $data['token_type'] ?? null;
        $this->hajjPayment->action = "SALE";
        $this->hajjPayment->currency_code = $data['currency_code'] ?? null;
        $this->hajjPayment->value = $data['value'] ?? null;
        $this->hajjPayment->payment_status = 'PENDING';
        $this->hajjPayment->expires_at = Carbon::now()->addSeconds(300);
        if ($this->hajjPayment->save())
            return $this->hajjPayment;

        return false;
    }

    public function update($request, $id,$json =null)
    {
        $payment = $this->hajjPayment->find($id);
        $payment->payment_token = $request['access_token'] ?? $payment->payment_token;
        $payment->payment_token_type = $request['token_type'] ?? $payment->payment_status;
        $payment->payment_status = $request['payment_status'] ?? $payment->payment_status;
        $payment->get_token =$json!= null ?json_encode($json) :$payment->get_token;
        if ($payment->save())
            return $payment;


        return false;
    }

    public function isExpired($id)
    {
        $payment = $this->hajjPayment->find($id);
        return $payment->expires_at < now();
    }

    public function getByid($id)
    {
        return $this->hajjPayment->with('getUser','getHajj')->find($id);
    }

    public function getByHajj($hajj_id)
    {
        return $this->hajjPayment->where('hajj_request_id', $hajj_id)->get();
    }

    public function checkPaymentStatus(int $id)
    {
        $payment = $this->hajjPayment->find($id);

        return $payment->payment_status;
    }


}
