<?php

namespace App\Sys\Api;

use App\Models\Guest;
use App\Models\TestCase;
use App\Sys\Services;
use App\TBO;

class TBOAirServices extends Services
{
    use TBO;

    public function Auth()
    {
        // 'UserName'=>'Onttest',
        // 'Password'=>'Ot@131020',
        $paramter = [

            'UserName' => env('TBO_STAGING_API_USERNAME_Air'),
            //'UserName' =>'Onttest',
            'Password' => env('TBO_STAGING_API_PASSWORD_Air'),
           // 'Password' => 'Ot@131020',
            "BookingMode" => "API",
            "IPAddress" => ""
        ];

        $result = $this->TBO('post', 'Authenticate/ValidateAgency', $paramter, 'air');
        if ($result['IsSuccess'] == true)
            return $result;


        $errors =  $result['Errors'][0]['UserMessage'] ?? "Not Authenticated from TBo"  ;
        $this->setError($errors);
        return false;

    }

    public function search($data)
    {
        $result = $this->TBO('post', 'Search/Search', $data, 'air');
        if ($result['IsSuccess'] == true)
             return $result;



        $errors =  $result['Errors'][0]['UserMessage'] ?? "Have Errors";
        $this->setError($errors);
        return false;
    }

    public function upSell($data)
    {
       $result = $this->TBO('post', 'Detail/AddOnFares', $data, 'air');
        if ($result['ErrorMessage'] == null)
            return $result['FlightResults'];


        return false;
    }

    public function fareRule($data)
    {
        $result = $this->TBO('post', 'Detail/FareRule', $data, 'air');
        if ($result['IsSuccess'] == true)
            return $result['FareRules'];



        $errors = ['errors' => $result['Errors'][0]['UserMessage'] ?? "Have Errors" ] ;
        $this->setError($errors);
        return false;
    }

    public function fareQuote($data)
    {
        $result = $this->TBO('post', 'Detail/FareQuote', $data, 'air');
        if ($result['IsSuccess'] == true)
            return $result;




        $errors = ['errors' => $result['Errors'][0]['UserMessage'] ?? "Have Errors" ] ;
        $this->setError($errors);
        return false;
    }

    public function getSSR($data)
    {
        $result = $this->TBO('post', 'Detail/GetSSR', $data, 'air');
        if ($result['IsSuccess'] == true)
            return $result;


        $errors = ['errors' => $result['Errors'][0]['UserMessage'] ?? "Have Errors" ] ;
        $this->setError($errors);
        return false;
    }

   public function BookingNoncLcc($data)
   {
       $result = $this->TBO('post', 'Booking/Book', $data, 'air');
       $id = request()->attributes->get('guest_id');
       if($result['IsSuccess'] == true)
       {
           $guest = Guest::find($id);
           $guest->resultId = $data->ResultId;
           $guest->save();
           return $result;
       }



       $errors = $result['Errors'][0]['UserMessage'] ?? "Have Errors";
       $this->setError($errors);
       return false;
   }

   public function Ticket($data)
   {
       $result = $this->TBO('post', 'Booking/Ticket', $data, 'air');
         if($result['IsSuccess'] == true || ($result['PNR'] != "-" && $result['PNR'] != null))
            return $result;


       $errors = $result['Errors'][0]['UserMessage'] ?? "Have Errors";
       $this->setError($errors);
       return false;
   }

   public function getDitals($data)
   {
       $result = $this->TBO('post', 'Booking/GetBookingDetails', $data, 'air');
       if($result['IsSuccess'] == true)
       {
           $data['Itinerary'] =$result['Itinerary'];
           $data['ShowFailedReason'] =$result['ShowFailedReason'];
           $data['isPassportRequiredAtTicket'] =$result['isPassportRequiredAtTicket'];
           $data['OnlineRefund'] =$result['OnlineRefund'];
           $data['VoidApplicable'] =$result['VoidApplicable'];
           return $data;
       }
       if($result['Errors'] != null)
       {
           $errors =  is_array($result['Errors']) ? $result['Errors'][0]['UserMessage'] : $result['Errors'];
           $this->setError($errors);
           return  false;
       }

       $this->setError('this token_id or PNR incorrect ');
       return  false;

   }
}
