<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;

class Client  extends Authenticatable implements JWTSubject
{
    protected $connection ="mysql2";
    protected $table = 'cl_client';

    public function getAuthIdentifierName()
    {
        return 'client_phone';
    }
    public $timestamps = false;

    public function getJWTIdentifier()
    {
        return $this->client_phone;
    }

    public function getJWTCustomClaims()
    {
        return [
            'client_phone'=>$this->client_phone,
            'client_name_en'=>$this->client_name_en
        ];
    }
}
