<?php

namespace App\Http\Resources;

use App\Models\Countries;
use Illuminate\Http\Resources\Json\JsonResource;

class UsersResources extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            "client_name_ar"=>$this->client_name_ar,
            "client_name_en"=>$this->client_name_en,
            "client_phone"=>$this->client_phone,
            "client_address"=>$this->client_address_1,
            "client_email"=>$this->client_email,
            "residency"=>$this->residency,
            "nationality"=>$this->nationality,
            "nationallity_name"=>$this->getCountryName($this->nationality),
            "residency_name"=>$this->getCountryName($this->residency),
             "wallet"=>$this->wallet
        ];
    }

    public function getCountryName($code)
    {
        if($code != null)
        {
            $country = Countries::where('code',$code)->first();
            if($country != null)
                return $country->name_en;


            return null;
        }

        return null;
    }
}
