<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class HajjPassportDetailsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'first_name'=>$this->first,
            'second_name'=>$this->second,
            'last_name'=>$this->last,
            'third_name'=>$this->third,
            'passport_number'=>$this->passport_number,
            'passport_expiry_date'=>$this->passprotEx(),
            'birth_day'=>$this->BirthDay(),
            'photo'=>$this->photo,
            'hosting_file'=>$this->hosting_file,
            'passport_type'=>$this->passport_type,
            'price'=>$this->price
        ];
    }

    private function passprotEx()
    {
        $date = Carbon::createFromDate(
            $this->passport_expire_year,
            $this->passport_expire_month,
            $this->passport_expire_day,
        );
        return $date->format('Y-m-d');

    }
    private function BirthDay()
    {
        $date = Carbon::createFromDate(
            $this->birth_year,
            $this->birth_month,
            $this->birth_day,
        );
        return $date->format('Y-m-d');
    }
}
