<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CountryHajjResource extends JsonResource
{
    protected $type;

    public function __construct($resource, $type)
    {
        parent::__construct($resource);
        $this->type = $type;
    }
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'name'=>$this->name_en ?? $this->name_ar ?? null,
            'code'=>$this->code ?? null,
            "price_adult"=>$this->priceAdult(),
            "price_child"=>$this->priceChild(),
            'need_hosting_file'=> $this->id == 24? true : false,
        ];
    }

    private function priceAdult()
    {

        return $this->type == "umrah" ? $this->umrah_price_adult : $this->hajj_price_adult;
    }
    private function priceChild()
    {
        return $this->type == "umrah" ? $this->umrah_price_child : $this->hajj_price_child;
    }
}
