<?php

namespace App\Http\Controllers\api;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Controllers\PaymentAPI;
use App\Sys\Services\PaymentService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PaymentOrderController extends Controller
{
    use ApiResponse;
    private $payment;

    public function __construct()
    {
        $this->payment = new PaymentService();
    }
    public function index(Request $request)
    {
        $generate = $this->payment->getAuthToken($request);
        return response(
            $generate,
            $generate['status']
        );
    }

    public function pay(Request $request)
    {
        $payment = $this->payment->pay($request);
        $data = [
            'status' => 200,
            'message' => 'pay',
            'data' => $payment
        ];
        return response(
            $data,
         200
        );
    }

    public function savePaymentStatus(Request $request)
    {
        $result = $this->payment->savePaymentStatus($request);
        $this->checkPaymentStatus($result->id);
    }

    public function checkPaymentStatus($id)
    {
        $paymentStatus = $this->payment->checkPaymentStatus($id);
        return response(
            $paymentStatus,
            $paymentStatus['status']
        );
    }

    public function getURL($payment_code,$user_id)
    {
        $payment = $this->payment->find($payment_code);
        $user = $user_id;
        if ($payment->isExpired()) {
            return response(['message' => 'session time out'], 419);
        }
        if ($payment->user_id == $user) {
            $resposn = json_decode($payment->response_json,true);
            $redirect_url = isset($resposn['redirect_link']) && $resposn['redirect_link'] != null ? $resposn['redirect_link']."&paymentId=$payment_code" : route('finished');
            return view('payment')->with('type',$payment->type)->with('payment_code', $payment_code)->with('user_id', $user)->with('redirect_url', $redirect_url);
        }
        return response(['message' => 'access denied'], 403);
    }


}
