<?php

namespace App\Http\Controllers\api\Hajj;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\CitiesCollection;
use App\Http\Resources\CountryHajjResource;
use App\Http\Resources\HajjCollection;
use App\Http\Resources\HajjDetailsCollection;
use App\Http\Resources\HajjPassportDetailsCollection;
use App\Http\Resources\HajjPassportDetailsResource;
use App\Models\Cities;
use App\Models\Countries;
use App\Models\HajjPassportDetails;
use App\Sys\Services\Hajj\HajjServices;
use Illuminate\Http\Request;

class HajjApiController extends Controller
{
    use ApiResponse;

    private $hajjService;

    public function __construct()
    {
        $this->hajjService = new HajjServices();
    }

    public function getPricesByNational($id)
    {
        $country = Countries::find($id);
        if (!empty($country)) {
            $data = [
                'hajj_adult' => $country->hajj_price_adult,
                'hajj_child' => $country->hajj_price_child,
                'umrah_adult' => $country->umrah_price_adult,
                'umrah_child' => $country->umrah_price_child,
                'need_hosting_file' => $id == 24 ? true : false, // Assuming 24 is the ID for Sudan
            ];
            return $this->apiResponse(200, 'Hajj prices by national', null, $data);
        }
        return $this->apiResponse(404, 'Country not found', null, null);
    }

    public function hajjRequest(Request $request)
    {

        if ($hajj = $this->hajjService->add($request->all())) {
            return $this->apiResponse(200, 'Hajj request created successfully', null, ['code' => $hajj->code]);
        }

        $errors = $this->hajjService->errors();
        return $this->apiResponse(201, 'Failed to create Hajj request', $errors, null);

    }

    public function list()
    {
        $data = $this->hajjService->list();
        $clolect = new HajjCollection($data);
        return $this->apiResponse(200, 'Hajj requests list', null, $clolect);
    }

    public function getDetials($id)
    {
        $data = $this->hajjService->getDeitals($id);
        $clolect = new HajjDetailsCollection($data);
        return $this->apiResponse(200, 'Hajj requests list', null, $clolect);
    }

    public function getCountryType($type)
    {
        if (in_array($type, ['hajj', 'umrah'])) {
            $colmue = 'accepts_' . $type . '_visa';
            $data = Countries::where($colmue, 1)->get();
            $collect = collect($data)->map(function ($item) use ($type) {
                return new CountryHajjResource($item, $type);
            });
            return $this->apiResponse(200, 'Countries list for ' . $type, null, $collect);
        }
        return $this->apiResponse(201, 'Invalid type', ['Invalid type'], null);

    }

    public function getCitiesByCountry($id)
    {
        $cities = Cities::where('country_id', $id)->get();
        $collect = new CitiesCollection($cities);
        return $this->apiResponse(200, 'Cities List', null, $collect);
    }

    public function payment($id)
    {
       if($data=$this->hajjService->payment($id))
           return $this->apiResponse(200, 'Hajj request created successfully', null, $data);


       $errors = $this->hajjService->errors();
       return $this->apiResponse(201, 'Failed to create Hajj request', $errors, null);
    }

    public function downloadFile()
    {
        $file = public_path('Hosting_and_Departure_Guarantee_Declaration.docx');
        return $this->apiResponse(200, 'File download link', null, ['file' => $file]);
    }

    public function getURL($payment_code, $user_id)
    {
        $payment = $this->hajjService->checkPayment($payment_code);
        $user = $user_id;
        if ($payment->expires_at < now()) {
            return response(['message' => 'session time out'], 419);
        }
        if ($payment->user_id == $user) {
            $redirect_url = request()->has('redirect_links') ? request()->redirect_links . "&paymentId=$payment_code" : route('finished');
            return view('hajj_payment')->with('payment_code', $payment_code)->with('user_id', $user)->with('redirect_url', $redirect_url);
        }
        return response(['message' => 'access denied'], 403);
    }

    public function accessToken(Request $request)
    {
        if ($payment = $this->hajjService->getAuthToken($request)) {
            $data = [
                'status' => 200,
                'message' => 'access token',
                'token' => $payment->payment_token,
            ];
            return response(
                $data,
                200,
            );
        }

        $errors = $this->hajjService->errors();
        return response(
            $errors,
            $errors['status'] ?? 400,
        );

    }

    public function pay(Request $request)
    {
        if ($payment = $this->hajjService->pay($request)) {
            $data = [
                'status' => 200,
                'message' => 'pay',
                'data' => $payment
            ];
            return response(
                $data,
                200
            );
        }

        $errors = $this->hajjService->errors();
        return response(
            $errors,
            $errors['status'] ?? 400
        );


    }

    public function PaymentStatus(Request $request)
    {
        $content = $request->getContent();
        $json = json_decode($content);
        $data = [
            'activity_status' => "paid",
            'payment_status' => $json->activity_status,
            'id' => $json->payment_code
        ];
        if ($respo = $this->hajjService->paymentStatus($data)) {
            return response(
                $respo,
                200
            );
        }

        $errors = $this->hajjService->errors();
        return response(
            $errors,
            $errors['status'] ?? 400
        );

    }

    public function checkingBooking($id)
    {
        if ($hajj = $this->hajjService->checkingBooking($id))
            return $this->apiResponse(200, 'Checking booking', null, $hajj);


        return $this->apiResponse(201, 'Checking booking', ['Not Found'], null);

    }


}
