<?php

namespace App\Sys\Services;

use App\Models\Guest;
use App\Models\PaymentOrder;
use App\PaymentAPI;
use App\Sys\Repository\PaymentRepo;
use App\Sys\Services;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use URL;

class PaymentService extends Services
{
    use PaymentAPI;

    private $payment;

    public function __construct()
    {
        $this->payment = new PaymentRepo();
    }

    public function getWebview($request, $json)
    {
        if ($result = $this->payment->generate($request, $json)) {
            return $result;
        }
        return false;
    }

    public function getAuthToken($request)
    {
        $content = $request->getContent();
        $json = json_decode($content);
        $payment_code = $json->payment_code;
        $response = $this->PaymentAPI(
            ['grant_type' => 'client_credentials'],
            [
                "Content-Type" => "application/vnd.ni-identity.v1+json",
                "Authorization" => "Basic " . config("services.third_party.webhook")
            ], "identity/auth/access-token", "post"
        );

        $p = PaymentOrder::find($payment_code);
        $p->get_token = json_encode($response);
        $p->save();
        if ($generate = $this->payment->update($response, $payment_code)) {
            return [
                'status' => 200,
                'message' => 'access token',
                'token' => $generate->payment_token,
            ];
        }
        return [
            'status' => 400,
            'message' => 'access token',
            'errors' => 'order not found try again'
        ];
    }

    public function pay($request)
    {
        // get content
        $content = $request->getContent();
        $json = json_decode($content);
        $payment_code = $json->payment_code;
        $user = $json->the_code;
        // check
        //$guest = request()->attributes->get('guest_id');
        //$user = Auth::guard('api')->user();

        $redirect_url = URL::route('finished');
        $payment = $this->payment->find($payment_code);
        if (!empty($payment)) {


            if ($payment->isExpired()) {
                return [
                    'status' => 419,
                    'message' => 'pay',
                    'error' => 'session expired'
                ];
            }
            if ($payment->user_id != $user) {
                return [
                    'status' => 403,
                    'message' => 'pay',
                    'error' => 'access denied'
                ];
            }
            $gues = Guest::find($payment->guest_id);
            $expiredTime = $payment->type == "hotel" ? Carbon::parse($gues->hotel_time) : Carbon::parse($gues->air_time);
            $remainingMinutes = (int) $expiredTime->greaterThan(Carbon::now())
                ? $expiredTime->diff(Carbon::now())->format('%I')
                : '0';
            //$remainingMinutes = (int)$expiredTime->diff(Carbon::now())->format('%I');
            if ($remainingMinutes == 0) {
                return [
                    'status' => 419,
                    'message' => 'pay',
                    'error' => 'session expired'
                ];
            }
            $params = [
                "action" => $payment->action ?? "PURCHASE",
                "amount" => [
                    "currencyCode" =>"AED", //"", // $payment->currency_code ?? "AED",
                    "value" => $payment->value
                ],
                "language" => "en",
                "payment" => [
                    "currency" => "AED" //"AED" //$payment->currency_code ?? "AED"
                ],
                "merchantAttributes" => [
                    "redirectUrl" => $redirect_url,
                    "skip3DS" => false,
                    "skipConfirmationPage" => false
                ]
            ];
            // هنشوف هيعصل ايه

            try {
                $response = $this->PaymentAPI(
                    $params,
                    [
                        'Accept' => "application/vnd.ni-payment.v2+json",
                        'Content-type' => "application/vnd.ni-payment.v2+json",
                        'Authorization' => "Bearer " . $payment->payment_token,
                    ],
                    "transactions/outlets/" . config('services.third_party.outlet') . "/payment/hosted-session/" . $json->sessionID
                    , "post"
                );

                $pa = PaymentOrder::find($payment_code);
                $pa->session_id = $json->sessionID;
                $pa->token = $json->token;
                $pa->pay_response = json_encode($response);
                $pa->save();

                return $response;
            } catch (\Throwable $th) {
                return [
                    'status' => $th->getCode() == 0 ? 500 : $th->getCode(),
                    'message' => 'pay',
                    'error' => $th->getMessage()
                ];
            }
        }

    }

    public function find($id)
    {
        if ($payment = $this->payment->find($id))
            return $payment;


        return false;
    }

    public function savePaymentStatus($request)
    {
        $content = $request->getContent();
        $json = json_decode($content);
        $data = [
            'activity_status' => "paid",
            'payment_status' => $json->activity_status,
        ];
        return $this->payment->update($data, $json->payment_code);
    }

    public function checkPaymentStatus($id)
    {
        if ($status = $this->payment->checkPaymentStatus($id)) {
            return [
                'status' => 200,
                'message' => 'check status',
                'payment_status' => $status
            ];
        }
        return [
            'status' => 404,
            'message' => 'check status',
            'errors' => 'payment order not found'
        ];

    }

    public function isExpired($id)
    {
        return $this->payment->isExpired($id);
    }

    public function findHotel($id)
    {
        return $this->payment->findHotel($id);
    }

    public function checkStatus($id, $data = null)
    {
        $orders = $data;
        if ($data == null) {
            $payment = $this->payment->find($id);
            $orders = json_decode($payment->pay_response, true);
        }
        if (!empty($orders)) {
            $token = $this->getAccsessToken();
            $end = 'transactions/outlets/' . $orders['outletId'] . '/orders/' . $orders['orderReference'];
            $response = $this->PaymentAPI(null,
                [
                    'Accept' => "application/vnd.ni-payment.v2+json",
                    'Content-type' => "application/vnd.ni-payment.v2+json",
                    'Authorization' => "Bearer " . $token,
                ],
                $end
                , "GET"
            );

            /*
            if (isset($response['_embedded']['payment'][0]['state']) && $response['_embedded']['payment'][0]['state'] === 'CAPTURED') {

                if (isset($response['_embedded']['payment'][0]['_embedded']['cnp:capture'][0]['_links']['cnp:refund']['href'])) {
                    $url =  $response['_embedded']['payment'][0]['_embedded']['cnp:capture'][0]['_links']['cnp:refund']['href'];
                    $link =  $this->extractRefundLink($url);
                    $params = [
                        "amount" => [
                            "currencyCode" => $payment->currency_code,
                            "value" => $payment->value
                        ]
                    ];
                    return $this->refund($link,$params);
                }
            }
            */
            return $response;
        }
        return false;
    }

    public function refund($url, $data)
    {
        $token = $this->getAccsessToken();
        return $this->PaymentAPI($data,
            [
                'Accept' => "application/vnd.ni-payment.v2+json",
                'Content-type' => "application/vnd.ni-payment.v2+json",
                'Authorization' => "Bearer " . $token,
            ], $url, "POST"
        );
    }


    public function updated()
    {
        if ($this->payment->update($data, $payment_code)) {
            return [
                'status' => 200,
                'message' => 'pay',
                'data' => $response
            ];
        }
        return [
            'status' => 400,
            'message' => 'pay',
            'error' => 'error on saving data'
        ];
    }

    public function getAccsessToken()
    {
        $response = $this->PaymentAPI(
            ['grant_type' => 'client_credentials'],
            [
                "Content-Type" => "application/vnd.ni-identity.v1+json",
                "Authorization" => "Basic " . config("services.third_party.webhook")
            ], "identity/auth/access-token", "post"
        );

        return $response['access_token'];
    }

    public function extractRefundLink($url)
    {
        if ($url != null) {
            $urlParts = explode("transactions/", $url);
            if (isset($urlParts[1])) {
                return "transactions/" . $urlParts[1];
            }
        }

        return null;
    }


}
