<?php

namespace App\sys\Services\Hotel;

use App\Http\Resources\HotelResource;
use App\Models\Guest;
use App\Models\Result;
use App\Models\Reservation;
use App\sys\Api\TBOServices;
use App\Sys\Services;
use App\Sys\Services\PaymentService;
use App\TBO;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use App\Jobs\ProcessHotelCodeChunks;

class HotelServices extends Services
{
    private $tbo;
    private $payment;


    public function __construct()
    {
        $this->tbo = new TBOServices();
        $this->payment = new PaymentService();
    }

    public function getCountry()
    {
        return $this->tbo->getCountry();
    }

    public function city($code)
    {
        return $this->tbo->getCity($code);
    }

    public function getHotelCodeByCity($code, $is_detailed, $layout = 'normal')
    {
        return $this->tbo->HotelByCity($code, $is_detailed, $layout);
    }

    public function SearchRoom($data)
    {
        $id = request()->attributes->get('guest_id');
        if ($rooms = $this->tbo->searchRooms($data)) {
            $gues = Guest::find($id);
            $gues->hotel_time = Carbon::now()->addMinutes(18);
            $gues->save();
            $expiredTime = Carbon::parse($gues->hotel_time);
            //$remainingMinutes = $expiredTime->diff(Carbon::now())->format('%I:%S');
            $remainingMinutes =  $expiredTime->greaterThan(Carbon::now())
                ? $expiredTime->diff(Carbon::now())->format('%I:%S')
                : '00:00';
            //$remainingMinutes2 = (int)$expiredTime->diff(Carbon::now())->format('%I');
            $data = ['data' => $rooms,
                'time' => [
                    'expired_time' => $expiredTime->format('Y-m-d H:i:s'),
                    'time_now' => Carbon::now()->format('Y-m-d H:i:s'),
                    'remaining_time' => $remainingMinutes
                ]
            ];
            return $data;
        }


        $this->setError($this->tbo->errors());
        return false;
    }

    public function SearchHotel($parmter)
    {
        //get hotel :)
        $id = request()->attributes->get('guest_id');
        $h = Result::where([['guest_id', $id], ['type', 'hotel']])->first();
        if (!empty($h)) {
            $search = json_decode($h->search, true);
            $arr = Arr::except(request()->all(), ['page', 'per_page', 'min', 'max', 'hotel_name', 'cases']);
            $a = array_diff_assoc($arr, $search);
            if (empty($a)) {
                $hotelData = json_decode($h->properties);
                $count = count($hotelData);
                $page = request()->page;
                $perPage = request()->per_page;
                $totalPages = ceil($count / $perPage);
                $offset = ($page - 1) * $perPage;

                $rueslt['default-min'] = $count > 0 ? (float)collect($hotelData)->min('price') : 0;
                $rueslt['default-max'] = $count > 0 ? (float)collect($hotelData)->max('price') : 0;
                // check prices data
                if (((isset(request()->min) && request()->min != null) && (isset(request()->max) && request()->max != null)) || (isset(request()->hotel_name) && request()->hotel_name != null))
                    $hotelData = $this->fillterPrices(request()->min, request()->max, $hotelData, request()->hotel_name);


                $rueslt['data'] = array_slice((array)$hotelData, $offset, $perPage);
                $rueslt['count'] = count((array)$hotelData);
                $rueslt['search-min'] = isset(request()->min) && request()->min != null ? (int)request()->min : $rueslt['default-min'];
                $rueslt['search-max'] = isset(request()->max) && request()->max != null ? (int)request()->max : $rueslt['default-max'];
                return $rueslt;
            }
        }

        if ($data = $this->resultshotel($parmter, $id)) {
            return $data;
        }
        $this->setError($this->tbo->errors());
        return false;
    }

    private function resultshotel($parmter, $id)
    {
        // Get all hotel codes for the city
        $allCodes = $this->tbo->HotelByCity(request()->city, false, 'array');
        if (empty($allCodes)) {
            $this->setError(['There are no hotels in this city']);
            return false;
        }



        // Chunk into batches of up to 100
        $chunks = array_chunk($allCodes, 100);

        $firstNonEmpty = null;
        $firstBatchIndex = null;
        foreach ($chunks as $index => $batch) {
            $batchResults = $this->tbo->searchHotelByCodes($batch, $parmter);
            if (!empty($batchResults)) {
                $firstNonEmpty = $batchResults;
                $firstBatchIndex = $index;
                break;
            }
        }

        if ($firstNonEmpty === null) {
            $this->setError($this->tbo->errors());
            return false;
        }

        // Save first batch and compute response immediately
        $data = $this->addHotel($firstNonEmpty, $id);
        $hotels = json_decode($data->properties);
        $count = count($hotels);
        $page = request()->page;
        $perPage = request()->per_page;
        $totalPages = ceil($count / $perPage);
        $offset = ($page - 1) * $perPage;

        $rueslt['default-min'] = $count > 0 ? (float)collect($hotels)->min('price') : 0;
        $rueslt['default-max'] = $count > 0 ? (float)collect($hotels)->max('price') : 0;

        if (((isset(request()->min) && request()->min != null) && (isset(request()->max) && request()->max != null)) || (isset(request()->hotel_name) && request()->hotel_name != null))
            $hotels = $this->fillterPrices(request()->min, request()->max, $hotels, request()->hotel_name);

        $rueslt['data'] = array_slice((array)$hotels, $offset, $perPage);
        $rueslt['count'] = count((array)$hotels);
        $rueslt['search-min'] = isset(request()->min) && request()->min != null ? (int)request()->min : $rueslt['default-min'];
        $rueslt['search-max'] = isset(request()->max) && request()->max != null ? (int)request()->max : $rueslt['default-max'];

        // Dispatch background job to process remaining chunks and merge
        $remainingChunks = array_slice($chunks, $firstBatchIndex + 1);
        if (!empty($remainingChunks)) {
            ProcessHotelCodeChunks::dispatch($remainingChunks, $parmter, $id)->onQueue('hotels');
        }

        return $rueslt;
    }

    public function fillterPrices($min, $max, $data, $name)
    {
        $mixR = $min != null ? $min : (float)collect($data)->min('price');
        $maxR = $min != null ? $max : (float)collect($data)->max('price');
        $filteredHotels = collect($data)->filter(function ($hotel) use ($mixR, $maxR, $name) {
            if ($name != null)
                return $hotel->price >= $mixR && $hotel->price <= $maxR && stripos($hotel->hotel_name, $name) !== false;

            return $hotel->price >= $mixR && $hotel->price <= $maxR;
        });


        return json_decode($filteredHotels);
    }

    public function getPerBook($data, $company)
    {
        $id = request()->attributes->get('guest_id');
        $gues = Guest::find($id);
        $expiredTime = Carbon::parse($gues->hotel_time);
        //$remainingMinutes = $expiredTime->diff(Carbon::now())->format('%I:%S');
        $remainingMinutes =  $expiredTime->greaterThan(Carbon::now())
            ? $expiredTime->diff(Carbon::now())->format('%I:%S')
            : '00:00';
        if ($company == 'tbo') {

            if ($hotel = $this->tbo->prebook($data)) {
                $data = ['data' => $hotel,
                    'time' => [
                        'expired_time' => $expiredTime->format('Y-m-d H:i:s'),
                        'time_now' => Carbon::now()->format('Y-m-d H:i:s'),
                        'remaining_time' => $remainingMinutes
                    ]
                ];
                return $data;
            }


            $this->setError($this->tbo->errors());
            return false;
        }
        return false;
    }

    public function tboBooking($data, $paymentStatus, $id)
    {
        if ($this->tbo->booking($data)) {
            // Save Data
            $hotel = $this->tbo->getData();
            if ($reves = $this->addReservation($hotel, 'tbo', $data, $paymentStatus['id'], $id)) {
                $hotel['reservation'] = $reves;
                $this->setData($hotel);
                return true;
            }
            return false;
        }
        $this->setError($this->tbo->errors());
        return false;
    }

    public function cancel($data, $comp)
    {
        if ($comp == "tbo") {
            if ($this->tbo->cancel($data)) {
                $hotel = $this->tbo->getData();
                $this->setData($hotel);
                $this->updatedReservation($hotel['ConfirmationNumber']);
                return true;
            }

            $this->setError($this->tbo->errors());
            return false;
        }
    }

    public function addHotel($data, $id)
    {

        $h = Result::where([['guest_id', $id], ['type', 'hotel']])->first();
        if (!empty($h)) {
            $h->delete();
        }

        $addHotel = new Result();
        $addHotel->properties = $data;
        $addHotel->guest_id = $id;
        $addHotel->search = json_encode(Arr::except(request()->all(), ['page', 'per_page']));
        $addHotel->is_active = 1;
        $addHotel->type = 'hotel';
        $addHotel->save();
        return $addHotel;
    }

    public function mergeHotel($data, $guestId)
    {
        $h = Result::where([['guest_id', $guestId], ['type', 'hotel']])->first();
        if (empty($h)) {
            return $this->addHotel($data, $guestId);
        }

        $existing = json_decode($h->properties, true) ?: [];
        $incoming = json_decode(json_encode($data), true) ?: [];
        // Merge and de-duplicate by hotel_code
        $merged = array_values(collect(array_merge($existing, $incoming))
            ->unique(function ($item) {
                return $item['hotel_code'] ?? ($item['HotelInfo']['HotelCode'] ?? null);
            })->all());

        $h->properties = json_encode($merged);
        $h->save();
        return $h;
    }


    public function bookingDetails($confirm, $co, $ref = null)
    {
        $data = [
            'ConfirmationNumber' => $confirm,
            'BookingReferenceId' => $ref
        ];
        if ($co == "tbo") {
            if ($hotel = $this->tbo->bookingDetails($data)) {
                return $hotel;
            }
            $this->setError($this->tbo->errors());
            return false;
        }


    }

    public function changepassword(Request $request)
    {

    }

    public function updatedReservation($data)
    {
        $rese = Reservation::where('confirmation_number', $data)->first();
        $rese->status = 'cancel';
        return $rese->save();
    }

    public function addReservation($data, $com, $hotel, $paymentStatus, $id)
    {
        if (is_object($hotel)) {
            //$hotel = (array) $hotel;
            $arr = json_encode($hotel);
            $hotel = json_decode($arr, true);
        }
        if ($data['Status']['Code'] == 200) {
            $rese = new Reservation();
            $rese->guest_id = $id['guest'];
            $rese->payment_id = $paymentStatus;
            $rese->company = $com;
            $rese->client_referenceId = $data['ClientReferenceId'];
            $rese->confirmation_number = $data['ConfirmationNumber'];
            $rese->total_fare = $hotel['total']['final_price'];
            $rese->phone_number = $hotel['PhoneNumber'];
            $rese->payment = $hotel['PaymentMode'];//
            $rese->check_in = $hotel['check_in'];
            $rese->check_out = $hotel['check_out'];
            $rese->hotel_name = $hotel['hotel_name'];
            $rese->user_id = $id['id'];
            $rese->total = json_encode($hotel['total']);
            $rese->rome_name = $hotel['room_name'];
            $rese->save();
            return $rese->id;
        }

        return false;
    }

    public function getHotelDetails($data)
    {
        $data['Language'] = isset($data['Language']) && $data['Language'] != null ? $data['Language'] : 'EN';
        if ($hotel = $this->tbo->hotelDetials($data))
            return $hotel;

        $this->setError($this->tbo->errors());
        return false;
    }
}
