<?php

namespace App\Sys\Repository;

use App\PaymentAPI;
use App\Models\Airports;
use App\Models\PaymentOrder;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PaymentRepo
{
    use PaymentAPI;
    private $payment;

    public function __construct()
    {
        $this->payment = new PaymentOrder();
    }

    public function generate($request,$json)
    {
        $guest = request()->attributes->get('guest_id');
        $user = Auth::guard('api')->user();

        $this->payment->response_json =  json_encode($json);
        $this->payment->guest_id = $guest;
        $this->payment->type = $request['type'];
        $this->payment->user_id = $user->id;
        $this->payment->reservation_id = $request['reservation_id'] ?? null;
        $this->payment->air_reservation_id = $request['air_reservation_id'] ?? null;
        $this->payment->payment_token = $request['access_token'] ?? null;
        $this->payment->payment_token_type = $request['token_type'] ?? null;
        $this->payment->action = "SALE";
        $this->payment->currency_code = $request['currency_code'] ?? null;
        $this->payment->value = $request['value'] ?? null;
        $this->payment->activity_status = "PREBOOK";
        $this->payment->payment_status = "PENDING";
        $this->payment->expires_at = Carbon::now()->addSeconds(300);
        if ($this->payment->save())
            return $this->payment;


        return false;
    }

    public function find($id)
    {
        return $this->payment->find($id);
    }

    public function findHotel($id)
    {
        return $this->payment->with('hotel','air')->find($id);
    }

    public function update($request, $id)
    {
        $payment = $this->payment->find($id);
        $payment->reservation_id = $request['reservation_id'] ?? $payment->reservation_id;
        $payment->air_reservation_id = $request['air_reservation_id'] ?? $payment->air_reservation_id;
        $payment->payment_token = $request['access_token'] ?? $payment->payment_token;
        $payment->payment_token_type = $request['token_type'] ?? $payment->payment_status;
        $payment->activity_status = $request['activity_status'] ?? $payment->activity_status;  //
        $payment->payment_status = $request['payment_status'] ?? $payment->payment_status;  //
        if ($payment->save())
            return $payment;


        return false;
    }



    public function pay(int $id)
    {
        if ($payment = $this->payment->find($id)) {
                return $payment;
        }
        return [
            'status' => 404,
            'message' => 'pay',
            'errors' => 'order not found'
        ];
    }

    public function checkPaymentStatus(int $id)
    {
        $payment = $this->payment->find($id);

        return $payment->payment_status;
    }

    public function isExpired($id)
    {
        $payment = $this->payment->find($id);
        return $payment->isExpired();
    }


}
