<?php

namespace App\sys\Api;

use App\Http\Resources\HotelResource;
use App\Http\Resources\RoomsResource;
use App\Http\Resources\TBOPreBookResources;
use App\Models\TestCase;
use App\Sys\Services;
use App\TBO;

class TBOServices extends Services
{
    use TBO;

    public function getCountry()
    {
        $country = $this->TBO('get', 'CountryList', null, 'hotel');
        return $country['CountryList'];
    }

    public function getCity($code)
    {
        $city = $this->TBO('post', 'Citylist', ['CountryCode' => $code], 'hotel');
        return $city['CityList'];
    }

    public function HotelByCity($code, $is_detailed, $layout)
    {
        $pramter = [
            'CityCode' => (int)$code,
            'IsDetailedResponse' => $is_detailed
        ];
        $hotel = $this->TBO('post', 'TBOHotelCodeList', $pramter, 'hotel');
        if ($layout == "array") {
            if ($hotel['Status']['Code'] == 200)
                return collect($hotel['Hotels'])->pluck('HotelCode')->toArray();
            else
                return [];
        }
        return $hotel['Hotels'];
    }

    public function searchRooms($data)
    {

        $rooms = $this->TBO('POST', 'Search', $data, 'hotel');
        if ($rooms['Status']['Code'] == 200) {
            $hotel = $rooms['HotelResult'][0]['HotelCode'];
            $curr = $rooms['HotelResult'][0]['Currency'];
            $hotelSearchResults = collect($rooms['HotelResult'][0]['Rooms'])->map(function ($item) use ($hotel, $curr) {
                return new RoomsResource($item, 'tbo', $hotel, $curr);
            });
            return $hotelSearchResults;
        }
        $this->setError($rooms['Status']['Description']);
        return false;
    }

    public function searchHotel($data)
    {

        $hotel_code = $this->HotelByCity(request()->city, false, 'array');
        if ($hotel_code == null) {
            $this->setError(['There are no hotels in this city']);
            return false;
        }

        $limited_hotel_code = array_slice($hotel_code, 0, 100);
        $code = implode(',', $limited_hotel_code);
        //$code = "1000084,1000027,1000089,1000171,1000167,1000302,1000198,1000538,1000648,1000937,1000957,1000847,1000872,1001049,1001056,1001143,1001122,1001046,1463986,1491912";
        $data["HotelCodes"] = $code;

        $hotel = $this->TBO('POST', 'HotelSearch', $data, 'hotel');
        $id = request()->attributes->get('guest_id');
        if ($hotel['Status']['Code'] == 200) {
            $hotelSearchResults = collect($hotel['HotelSearchResults'])->map(function ($item) {
                return new HotelResource($item, 'tob');
            });

            return $hotelSearchResults;
        }


        $errors['code'] = $hotel['Status']['Code'];
        $errors['Description'] = $hotel['Status']['Description'];
        $this->setError($errors);
        return false;

    }

    /**
     * Search hotels by an explicit list of hotel codes (batch).
     * Accepts either an array of codes or a pre-joined comma string.
     */
    public function searchHotelByCodes($codes, $data)
    {
        if (is_array($codes)) {
            $code = implode(',', $codes);
        } else {
            $code = (string)$codes;
        }
        $data["HotelCodes"] = $code;

        $hotel = $this->TBO('POST', 'HotelSearch', $data, 'hotel');
        if (isset($hotel['Status']['Code']) && $hotel['Status']['Code'] == 200) {
            $hotelSearchResults = collect($hotel['HotelSearchResults'])->map(function ($item) {
                return new HotelResource($item, 'tob');
            });
            return $hotelSearchResults;
        }

        $errors['code'] = $hotel['Status']['Code'] ?? 0;
        $errors['Description'] = $hotel['Status']['Description'] ?? 'Unknown error';
        $this->setError($errors);
        return [];
    }

    public function prebook($data)
    {
        $hotel = $this->TBO('post', 'PreBook', $data, 'hotel');
        if ($hotel['Status']['Code'] == 200) {
            $hotelSearchResults = collect($hotel['HotelResult'])->map(function ($item) {
                return new TBOPreBookResources($item, 'tbo');
            });
            return $hotelSearchResults;
        }
        $errors['code'] = $hotel['Status']['Code'];
        $errors['Description'] = $hotel['Status']['Description'];
        $this->setError($errors);
        return false;
    }

    public function bookingDetails($data)
    {
        $hotel = $this->TBO('post', 'BookingDetail', $data, 'hotel');
        if ($hotel['Status']['Code'] == 200) {

            return $hotel;
        }
        $this->setError($hotel);
        return false;
    }

    public function booking($data)
    {
        if (is_string($data)) {
            $send = json_decode($data, true);
        } elseif (is_object($data)) {
            $send = (array)$data;
        } else {
            $send = $data;
        }
        // change totalfare to total
        $unwantedKeys = ['rome_name', 'hotel_name', 'check_in', 'check_out', 'room_name', 'country', 'payment_code', 'payment_type', 'currency', 'guestNationality','total','total_final'];
        foreach ($unwantedKeys as $key) {
            if (isset($send[$key])) {
                unset($send[$key]);
            }
        }
//$send =json_decode($send, true);
        $hotel = $this->TBO('post', 'Book', $send, 'hotel');
        //$hotel = $this->TBO('post', 'Book', $data, 'hotel');
        if ($hotel['Status']['Code'] == 200) {
            $this->setData($hotel);
            return true;
        }
        $this->setError($hotel);
        return false;
    }

    public function cancel($data)
    {
        $hotel = $this->TBO('post', 'Cancel', $data, 'hotel');
        if ($hotel['Status']['Code'] == 200) {
            $this->setData($hotel);
            return true;
        }
        $this->setError($hotel);
        return false;
    }

    public function hotelDetials($data)
    {
        $hotel = $this->TBO('post', 'HotelDetails', $data, 'hotel');
        if ($hotel['Status']['Code'] == 200)
            return $hotel['HotelDetails'];


        $this->setError($hotel);
        return false;
    }
}
