<?php

namespace App;

use GuzzleHttp\Client;

trait TBO
{

    public function TBO($method = "get" , $endPoint  ,$parameter = null,$type = "hotel" )
    {
        $client = new Client();
        if($type == "hotel")
        {
            $point = env('TBO_STAGING_API_SERVICE_URL').'/'.$endPoint;
            $auth = [env('TBO_STAGING_API_USERNAME'), env('TBO_STAGING_API_PASSWORD')];
            $options = [
                'headers' => ['Content-Type' => 'application/json'],
                'auth' =>$auth,
            ];
        }else{
            $url = env("TBO_STAGING_B2B_SERVICE_URL_Air");
            $point = $url.'/'.$endPoint;
            $options = [
                'headers' => ['Content-Type' => 'application/json'],
            ];
        }


        if (in_array(strtoupper($method), ['POST', 'PUT'])) {
            $options['json'] = $parameter;
        } else {
            $options['query'] = $parameter;
        }
        $response = $client->request($method, $point, $options);

        return json_decode($response->getBody(), true);


    }
}
