<?php

namespace App\Jobs;

use App\sys\Api\TBOServices;
use App\sys\Services\Hotel\HotelServices;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessHotelCodeChunks implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /** @var array<int, array<int, string>> */
    protected $chunks;

    /** @var array */
    protected $parameters;

    /** @var int */
    protected $guestId;

    public $timeout = 120;

    public function __construct(array $chunks, array $parameters, int $guestId)
    {
        $this->chunks = $chunks;
        $this->parameters = $parameters;
        $this->guestId = $guestId;
    }

    public function handle(): void
    {
        $tbo = new TBOServices();
        $service = new HotelServices();

        foreach ($this->chunks as $batch) {
            $results = $tbo->searchHotelByCodes($batch, $this->parameters);
            if (!empty($results)) {
                $service->mergeHotel($results, $this->guestId);
            }
        }
    }
}


