<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class HotelResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    protected $companyName;

    public function __construct($resource, $companyName)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
    }
    public function toArray($request)
    {
        $all =  $this->resource;
        $all['HotelInfo']['HotelPicture'] =$this['HotelInfo']['HotelPicture']??null;
        return [
            'company_name' => $this->companyName,
            'hotel_code' => $this['HotelInfo']['HotelCode'],
            'hotel_name' => $this['HotelInfo']['HotelName'],
            'photo' => $this['HotelInfo']['HotelPicture']??null,
            'description' => $this['HotelInfo']['HotelDescription']??null,
            'address' => $this['HotelInfo']['HotelAddress']??null,
            'longitude' => $this['HotelInfo']['Longitude']??null,
            'latitude' => $this['HotelInfo']['Latitude']??null,
            'rating' => $this['HotelInfo']['Rating']??null,
            'price' => $this['MinHotelPrice']['OriginalPrice'] * 3.67 ??null,
            'currency' => 'AED',
            'all_data'=> $all
        ];
    }
}
