<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class HajjPassportDetailsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'first_name'=>$this->first_name_en,
            'first_name_ar'=>$this->first_name_ar,
            'second_name'=>$this->second_name_en,
            'second_name_ar'=>$this->second_name_ar,
            'last_name'=>$this->last_name_en,
            'last_name_ar'=>$this->last_name_ar,
            'third_name'=>$this->third_name_en,
            'third_name_ar'=>$this->third_name_ar,
            'passport_number'=>$this->passport_number,
            'passport_expiry_date'=>$this->passprotEx(),
            'birth_day'=>$this->BirthDay(),
            'photo'=>$this->photo,
            'passport_doc'=>$this->passport_doc,
            'hosting_file'=>$this->hosting_file,
            'passport_type'=>$this->passport_type,
            'price'=>$this->price
        ];
    }

    private function passprotEx()
    {
        $date = Carbon::createFromDate(
            $this->passport_expire_year,
            $this->passport_expire_month,
            $this->passport_expire_day,
        );
        return $date->format('Y-m-d');

    }
    private function BirthDay()
    {
        $date = Carbon::createFromDate(
            $this->birth_year,
            $this->birth_month,
            $this->birth_day,
        );
        return $date->format('Y-m-d');
    }
}
