<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\ResourceCollection;

class HajjCollection extends ResourceCollection
{
    public function toArray(Request $request): array
    {
        return [
            'data' => $this->collection->map(fn($item) => (new HajjResource($item))->withDetails(false)),
            'links' => $this->paginationLinks(),
            'meta' => [
                'pagination' => [
                    'total' => $this->total(),
                    'count' => $this->count(),
                    'per_page' => $this->perPage(),
                    'current_page' => $this->currentPage(),
                    'total_pages' => $this->lastPage(),
                    'next_page' => $this->currentPage() ? $this->currentPage() + 1 : null,
                ],
            ],
        ];
    }

    protected function paginationLinks()
    {
        $paginator = $this->resource;


        $prevPage = $paginator->currentPage() - 1;
        $nextPage = $paginator->currentPage() + 1;


        $links =  $nextPage <= $paginator->lastPage() ? $paginator->url($nextPage) : null;

        return $links;
    }
}
