<?php

namespace App\Http\Middleware;

use App\Models\Guest;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Closure;

class checkGuest
{
    public function handle(Request $request, Closure $next)
    {


        /*
          $guest = $request->hasHeader('guest') ? $request->header('guest') : null;
           $check = Guest::where([
              ['token',$guest],['exp_time','>=',Carbon::now()]])->first();
          if(!empty($check))
          {
              $request->attributes->set('guest_token', $guest);
              $request->attributes->set('guest_id', $check->id);
              return $next($request);
          }
          return response(['status'=>403,'massage'=>'not authorized'], 403);

          */
        $old = $request->hasHeader('guest') ? $request->header('guest') : null;
        $guest = $request->hasHeader('Authorization') ? $request->header('Authorization') : null;
        if (Auth()->guard('api')->check()) {
            // check Guest
            $check = Guest::where([
                ['token', $guest]])->first();
            if (!empty($check)) {
                $request->attributes->set('guest_token', $guest);
                $request->attributes->set('guest_id', $check->id);
                return $next($request);
            }
            $guest = new Guest();
            $guest->token = $guest;
            $guest->client_id = Auth()->guard('api')->user()->id;
            $guest->exp_time = Carbon::now()->addDays(360);
            $guest->save();
        }

        $check = Guest::where([
            ['token', $old], ['exp_time', '>=', Carbon::now()]])->first();
        if (!empty($check)) {
            $request->attributes->set('guest_token', $guest);
            $request->attributes->set('guest_id', $check->id);
            return $next($request);
        }
        return response(['status' => 403, 'massage' => 'not authorized', 'errors' => "Unauthorized"], 403);

    }
}
