<?php

namespace App\Sys\Services\Air;

use App\Http\Resources\AirResource;
use App\Models\AirReservation;
use App\Models\Guest;
use App\Models\PaymentOrder;
use App\Models\Result;
use App\Models\TestCase;
use App\Sys\Api\TBOAirServices;
use App\Sys\Services;
use Carbon\Carbon;
use Illuminate\Support\Arr;

class AirServices extends Services
{
    private $guest;
    private $resultModel;
    private $tbo;

    public function __construct()
    {
        $this->guest = new Guest();
        $this->tbo = new TBOAirServices();
        $this->resultModel = new Result();
    }

    public function search($data)
    {
        // check guest Result
        $id = request()->attributes->get('guest_id');
        $air = $this->resultModel->where([['guest_id', $id], ['type', 'air']])->first();
        $gues = Guest::find($id);
        if (!empty($air)) {
            if ($result = $this->getFromResult($data, $id)) {
                $expiredTime = Carbon::parse($gues->air_time);
                $remainingMinutes = $expiredTime->diff(Carbon::now())->format('%I:%S');
                return $re = ['data' => $result,
                    'time' => [
                        'expired_time' => $expiredTime->format('Y-m-d H:i:s') ?? null,
                        'time_now' => Carbon::now()->format('Y-m-d H:i:s'),
                        'remaining_time' => $remainingMinutes
                    ]
                ];
            }


            $this->setError($this->errors());
            return false;
        }
        if ($result = $this->getSerachDataTBO($data, $id)) {
            $guest = Guest::find($id);
            $expiredTime = Carbon::parse($guest->air_time);
            //   $remainingMinutes = $expiredTime->diff(Carbon::now())->format('%I:%S');
            $remainingMinutes = $expiredTime->greaterThan(Carbon::now())
                ? $expiredTime->diff(Carbon::now())->format('%I:%S')
                : '00:00';
            return $data = ['data' => $result,
                'time' => [
                    'expired_time' => $expiredTime->format('Y-m-d H:i:s') ?? null,
                    'time_now' => Carbon::now()->format('Y-m-d H:i:s'),
                    'remaining_time' => $remainingMinutes
                ]
            ];
        }
        $this->setError($this->errors());
        return false;

    }

    public function searchDetailsTBO($data)
    {
        //get TokeId and ReuestId
        $id = request()->attributes->get('guest_id');
        $guest = $this->guest->find($id);
        $data->TokenId = $guest->air_token_id;
        $data->TrackingId = $guest->air_tracking_id;
        $totalFare = [];

            // result
        $myReuslt = [];
        /*
        if ($data->isLcc == false && $upSell = $this->getUpSell($data))
             $myReuslt['upSell'] = $upSell;
        else
            $myReuslt['upSell'] =[];
        */
        if ($fareRule = $this->fareRule($data))
            $myReuslt['fareRule'] = $fareRule;
        else
            $myReuslt['fareRule'] = $this->errors();


        if ($fareQuote = $this->fareQuote($data)) {
            $myReuslt['fareQuote'] = $fareQuote;
            $totalFare = $fareQuote['Result'][0]['Fare'];
        } else {
            $myReuslt['fareQuote'] = $this->errors();
        }


        if ($ssR = $this->getSSR($data))
            $myReuslt['ssR'] = $ssR;
        else
            $myReuslt['ssR'] = [];


        if (isset($myReuslt['fareRule']['errors']) || isset($myReuslt['fareQuote']['errors'])) {
            $this->setError($myReuslt['fareRule']['errors'] ?? 'have errors');
            return false;
        }

        if (!empty($totalFare)) {
            $tax = $totalFare['Tax'] ?? 0 + $totalFare['VATAmount'] ?? 0 + $totalFare['PenaltyAmount'] ?? 0 + $totalFare['ServiceFee'] ?? 0
            + $totalFare['AgentMarkup'] ?? 0 + $totalFare['OtherCharges'] ?? 0 + $totalFare['CreditCardCharge'] ?? 0;
            $netPrice = $totalFare['BaseFare'] ?? 0;
            $profit = $netPrice * 0.10;
            // السعر بعد الربح
            $priceWithProfit = $netPrice + $profit;
            $paymentFee = $priceWithProfit * 0.0225;
// السعر النهائي
            $finalPrice = $priceWithProfit + $paymentFee + $tax;

            $myReuslt['total'] = [
                'base_price' => $netPrice * 3.67,
                'profit_10_percent' => $profit * 3.67,
                'payment_fee_2_25' => $paymentFee * 3.67,
                'final_price' => $finalPrice * 3.67,
                'tax' =>$tax + $profit + $profit * 3.67,
                'total_fare_tbo' =>$totalFare['TotalFare'] * 3.67,
                'tbo_tax' => $tax * 3.67,
                "currency"=>"AED"
            ];
        }

        $expiredTime = Carbon::parse($guest->air_time);
        // $remainingMinutes = max($expiredTime->diffInMinutes(Carbon::now(), false), 0);
        $remainingMinutes = $expiredTime->greaterThan(Carbon::now())
            ? $expiredTime->diff(Carbon::now())->format('%I:%S')
            : '00:00';

        return $data = ['data' => $myReuslt,
            'time' => [
                'expired_time' => $expiredTime->format('Y-m-d H:i:s') ?? null,
                'time_now' => Carbon::now()->format('Y-m-d H:i:s'),
                'remaining_time' => $remainingMinutes
            ]
        ];


    }

    public function getUpSell($data)
    {
        if ($result = $this->tbo->UpSell($data))
            return $result;


        $this->setError($this->tbo->errors());
        return false;
    }

    public function fareRule($data)
    {
        if ($result = $this->tbo->fareRule($data))
            return $result;


        $this->setError($this->tbo->errors());
        return false;
    }

    public function fareQuote($data)
    {
        if ($result = $this->tbo->fareQuote($data))
            return $result;


        $this->setError($this->tbo->errors());
        return false;
    }

    public function getSSR($data)
    {
        if ($result = $this->tbo->getSSR($data))
            return $result;


        $this->setError($this->tbo->errors());
        return false;
    }

    public function AuthTbo()
    {
        $id = request()->attributes->get('guest_id');
        $guest = $this->guest->find($id);
        if ($guest->air_token_id !== null) {
            return true;
        }

        if ($data = $this->tbo->Auth()) {
            $guest->air_token_id = $data['TokenId'];
            $guest->air_tracking_id = $data['TrackingId'];
            return $guest->save();
        }

        return false;
    }

    private function getSerachDataTBO($data, $id)
    {
        $guest = $this->guest->find($id);
        $type = $data['JourneyType'];
        // fight type
        $data['TokenId'] = $guest->air_token_id;
        if ($search = $this->tbo->search($data)) {
            // Fromat

            $airSearchResults = collect($search['Results'][0])->map(function ($item) use ($type) {
                return new AirResource($item, 'tbo', $type);
            });
            $ruesl = $this->SaveResult($search, json_decode($airSearchResults), $data, $id);
            $guest->air_tracking_id = $search['TrackingId'];
            $guest->air_time = Carbon::now()->addMinutes(18);
            $guest->save();

            $count = count($airSearchResults);
            $page = $data['page'];
            $perPage = $data['per_page'];
            $totalPages = ceil($count / $perPage);
            $offset = ($page - 1) * $perPage;
            $returnRueslt['data'] = array_slice(json_decode($airSearchResults), $offset, $perPage);
            $returnRueslt['count'] = $count;
            return $returnRueslt;
        }
        $this->setError($this->tbo->errors());
        return false;
    }

    public function getFromResult($search, $id)
    {
        // check return data
        $air = $this->resultModel->where([['guest_id', $id], ['type', 'air']])->first();
        $guest = $this->guest->find($id);
        $search['TokenId'] = $guest->air_token_id;
        if (!empty($air)) {
            $oldsearch = json_decode($air->search, true);
            $arr = Arr::except($search, ['page', 'per_page', 'cases']);
            $a = array_udiff_assoc($oldsearch, $arr, function ($a, $b) {
                return $a <=> $b;
            });

            //$a = array_diff_assoc($oldsearch, $arr);
            if (empty($a)) {
                $airData = json_decode($air->properties);
                $count = count($airData);
                $page = $search['page'];
                $perPage = $search['per_page'];
                $totalPages = ceil($count / $perPage);
                $offset = ($page - 1) * $perPage;
                $rueslt['data'] = array_slice($airData, $offset, $perPage);
                $rueslt['count'] = $count;
                return $rueslt;
            }
        }
        // or return search
        if ($result = $this->getSerachDataTBO($search, $id))
            return $result;

        $this->setError($this->errors());
        return false;

    }

    public function SaveResult($searchResult, $flyResult, $data, $id)
    {

        // check to remove
        $air = $this->resultModel->where([['guest_id', $id], ['type', 'air']])->first();
        if (!empty($air)) {
            $air->delete();
        }
        $filteredData = Arr::except($data, ['page', 'per_page']);
        $encodedData = json_encode($filteredData);
        //Save Request
        $addAir = new Result();
        $addAir->properties = json_encode($flyResult);
        $addAir->all_properties = json_encode($searchResult);
        $addAir->guest_id = $id;
        $addAir->search = $encodedData;
        $addAir->is_active = 1;
        $addAir->type = 'air';
        $addAir->save();
        return $addAir;

    }

    public function bookingNoncLcc($data)
    {
        $id = request()->attributes->get('guest_id');
        $guest = $this->guest->find($id);
        $data->TokenId = $guest->air_token_id;
        $data->TrackingId = $guest->air_tracking_id;
        $expiredTime = Carbon::parse($guest->air_time);
        // $remainingMinutes = $expiredTime->diff(Carbon::now())->format('%I:%S');
        $remainingMinutes = $expiredTime->greaterThan(Carbon::now())
            ? $expiredTime->diff(Carbon::now())->format('%I:%S')
            : '00:00';
        if ($ruesalt = $this->tbo->BookingNoncLcc($data)) {
            return $data = ['data' => $ruesalt,
                'time' => [
                    'expired_time' => $expiredTime->format('Y-m-d H:i:s') ?? null,
                    'time_now' => Carbon::now()->format('Y-m-d H:i:s'),
                    'remaining_time' => $remainingMinutes
                ]];
            return $ruesalt;
            $data['SSRDenied'] = $ruesalt['SSRDenied'];
            $data['SSRMessage'] = $ruesalt['SSRMessage'];
            $data['PNR'] = $ruesalt['PNR'];
            $data['ChangeInItinerary'] = $ruesalt['ChangeInItinerary'];
            $data['TokenId'] = $ruesalt['TokenId'];
            $data['Itinerary'] = $ruesalt['Itinerary'];
            return $data;
        }

        $this->setError($this->tbo->errors());
        return false;

    }

    public function ticketForLcc($data, $paymentStatus, $id)
    {
        $guest = $this->guest->find($id['guest']);
        $data['TokenId'] = $guest->air_token_id;
        $data['TrackingId'] = $guest->air_tracking_id;
        $resultId =$data['ResultId'];
        if ($ruesalt = $this->tbo->Ticket($data)) {
            $this->SaveTicket($ruesalt, $data, $id, $resultId, $paymentStatus);
            return $ruesalt;
        }
        $this->setError($this->tbo->errors());
        return false;
    }


    public function getBookingDetalis($data)
    {
        $request['TokenId'] = $data['token_id'];
        $request['PNR'] = $data['pnr'];

        if ($rueslt = $this->tbo->getDitals($request))
            return $rueslt;


        $errors = $this->tbo->errors();
        $this->setError($errors);
        return false;
    }

    public function SaveTicket($ruesalt, $data, $id, $resultId, $paymentStatus)
    {
        // get Search data
        $searchData = $this->resultModel->where([['guest_id', $id['guest']], ['type', 'air']])->first();
        $mySearch = null;
        if (!empty($searchData)) {
            $search = json_decode($searchData->properties, true);

            $getSearch = collect($search)->filter(function ($air) use ($resultId) {
                return $air['resultId'] == $resultId;
            });

            $mySearch = $getSearch;
        }

        $ticket = new AirReservation();
        $ticket->guest_id = $id['guest'];
        $ticket->user_id = Auth()->guard('api')->check() ? Auth()->guard('api')->user()->id : $id['id'];
        $ticket->company = $data['company_name'];
        $ticket->token_id = $ruesalt['TokenId'] ?? null;
        $ticket->pnr = $ruesalt['PNR'] ?? null;
        $ticket->is_cll = $ruesalt['Itinerary']['IsLcc'] ?? null;
        $ticket->search = $mySearch != null ? json_encode($mySearch) : null;
        $ticket->response = json_encode($data);
        $ticket->result = json_encode($ruesalt);
        $ticket->payment_id = $paymentStatus['id'];
        $ticket->total = json_encode($data['total']);
        $ticket->save();
        if ($paymentStatus['id'] != null) {
            $py = PaymentOrder::find($paymentStatus['id']);
            $py->air_reservation_id = $ticket->id;
            $py->save();
        }

        return true;
    }
}
