<?php

namespace App\Sys\Repository;

use App\Models\HajjPassportDetails;
use App\Models\HajjRequest;
use Carbon\Carbon;
use Illuminate\Support\Str;

class hajjRepo
{
    public function add($data)
    {
        $hajj = new HajjRequest();
        $hajj->user_id = Auth()->guard('api')->user()->id;
        $hajj->national = $data['national'];
        $firstLetter = strtoupper(substr($data['type'], 0, 1));
        $hajj->code = $firstLetter . strtoupper(dechex(time())) . strtoupper(Str::random(3));
        $hajj->type = $data['type'];
        $hajj->country_id = $data['country_id']??null;
        $hajj->address = $data['address'];
        $hajj->city_id = $data['city_id']??null;
        $hajj->phone = $data['country_code'].$data['phone'];
        $hajj->stat = $data['stat'];
        $hajj->email = $data['email'];
        $hajj->day = $data['day'];
        $hajj->month = $data['month'];
        $hajj->year = $data['year'];
        $hajj->status = 'pending';
        $hajj->payment_status = null;
        if ($hajj->save()) {
            foreach ($data['detials'] as $detial) {
                $this->addDetails($hajj->id, $detial,$data);
            }

            $totalPrices = HajjPassportDetails::where('hajj_request_id', $hajj->id)
                ->sum('price');
            $hajj->total = $totalPrices;
            $hajj->save();
        }

        return $hajj;
    }

    private function addDetails($hajjId, $detials,$data)
    {
        $hajj = new HajjPassportDetails();
        $hajj->hajj_request_id = $hajjId;
        $hajj->first_name_en = $detials['first_name_en'];
        $hajj->first_name_ar = $detials['first_name_ar'];
        $hajj->second_name_en = $detials['second_name_en'];
        $hajj->second_name_ar = $detials['second_name_ar'];
        $hajj->third_name_en = $detials['third_name_en'];
        $hajj->third_name_ar = $detials['third_name_ar'];
        $hajj->last_name_en = $detials['last_name_en'];
        $hajj->last_name_ar = $detials['last_name_ar'];
        $hajj->passport_number = $detials['passport_number'];
        $hajj->passport_expire_day = $detials['passport_expire_day'];
        $hajj->passport_expire_month = $detials['passport_expire_month'];
        $hajj->passport_expire_year = $detials['passport_expire_year'];
        $hajj->birth_day = $detials['birth_day'];
        $hajj->birth_month = $detials['birth_month'];
        $hajj->birth_year = $detials['birth_year'];
        $hajj->photo = $detials['photo'] ?? null;
        $hajj->passport_doc = $detials['passport_doc'] ?? null;
        $hajj->hosting_file = $detials['hosting_file'] ?? null;
        $personality = $this->checkPersonalityType($detials,$data);
        $hajj->personality_type = $personality['type'] ?? null;
        $hajj->price = $personality['price'] ?? 0;
        $hajj->save();
    }

    private function checkPersonalityType($detials,$data)
    {
        $birthDate = Carbon::createFromDate(
            $detials['birth_year'],
            $detials['birth_month'],
            $detials['birth_day']
        );
        $age = $birthDate->age;
        $type = $age <= 12 ? 'child':'adult';
        return [
            'type' => $type,
            'price' => $data['price_' . $type] ?? 0
        ];

    }

    public function list()
    {
        $status = request()->has('status') && request()->status !== null ? explode(',', request()->status) : null;
        $payment_status = request()->has('payment_status') && request()->payment_status !== null ? explode(',', request()->payment_status) : null;
        $type=request()->type?? null;
        $limit = request()->limit ?? 10;

        return HajjRequest::with('passportDetails')->when($status,function ($q) use ($status) {
            $q->whereIn('status', $status);
        })->when($payment_status, function ($q) use ($payment_status) {
            $q->whereIn('payment_status', $payment_status);
        })->when($type, function ($q) use ($type) {
            $q->where('type', $type);
        })->where('user_id',Auth()->guard('api')->user()->id)
            ->orderBy('updated_at', 'desc')->paginate($limit);
    }

    public function getDeitals($id)
    {
        return HajjRequest::with('passportDetails')->where('id', $id)->get();
    }

    public function getByid($id)
    {
        return HajjRequest::find($id);
    }

    public function updateStatus($id, $status)
    {
        $hajj = HajjRequest::find($id);
        if (!empty($hajj)) {
            $hajj->status = $status;
            $hajj->save();
            return true;
        }
        return false;
    }

}
