<?php

namespace App;

use GuzzleHttp\Client;
//use Illuminate\Support\Facades\Http;

trait PaymentAPI
{
    public function PaymentAPI($params = null, $headers = null, $endpoint = 'identity/auth/access-token', $method = 'post')
    {
        $client = new Client();
        $url = config("services.third_party.base_url") . "/" . $endpoint;

        $options = [
            'headers' => $headers,
        ];

        if (in_array(strtoupper($method), ['POST', 'PUT'])) {
            $options['json'] = $params;
        } else {
            $options['query'] = $params;
        }

        \Log::info(json_encode($options));

        try {
            $response = $client->request($method, $url, $options);
            return $json = json_decode($response->getBody(), true);
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
