<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentOrder extends Model
{
    use HasFactory;
    use SoftDeletes;


    public function air()
    {
        return $this->belongsTo(AirReservation::class, "air_reservation_id");
    }

    public function hotel()
    {
        return $this->belongsTo(Reservation::class, "reservation_id");
    }

    public function isExpired()
    {
        return $this->expires_at < now();
    }
}
