<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\sys\Services\Hotel\HotelServices;
use App\Models\Reservation;

class HotelBookingSuccess extends Mailable
{
    use Queueable, SerializesModels;

    public $confirmationNumber;
    public $guestId;
    public $userId;
    public $reservationId;
    public $bookingDetail;
    public $reservationTotal;
    public $total;

    public function __construct($confirmationNumber, $guestId, $userId, $reservationId)
    {
        $this->confirmationNumber = $confirmationNumber;
        $this->guestId = $guestId;
        $this->userId = $userId;
        $this->reservationId = $reservationId;
    }

    public function build()
    {
        $hotelServices = new HotelServices();
        $details = $hotelServices->bookingDetails($this->confirmationNumber, 'tbo', null);
        $this->bookingDetail = is_array($details) && isset($details['BookingDetail']) ? $details['BookingDetail'] : null;

        $reservation = null;
        $this->reservationTotal = null;
        $this->total = null;
        if ($this->reservationId) {
            $reservation = Reservation::find($this->reservationId);
            if ($reservation) {
                // keep legacy numeric fallback if needed
                $this->reservationTotal = $reservation->total_fare ?? null;
                // decode totals JSON directly from reservation->total
                if (!empty($reservation->total)) {
                    $decoded = is_array($reservation->total) ? $reservation->total : json_decode($reservation->total, true);
                    if (is_array($decoded)) {
                        $this->total = $decoded;
                    }
                }
            }
        }

        return $this->view('mail.hotel_booking_success')
            ->with([
                'confirmationNumber' => $this->confirmationNumber,
                'booking' => $this->bookingDetail,
                'reservationTotal' => $this->reservationTotal,
                'total' => $this->total,
            ]);
    }
}
