<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class HajjRequestSuccess extends Mailable
{
    use Queueable, SerializesModels;

    public $code;
    public $message;

    public function __construct($code, $message)
    {
        $this->code = $code;
        $this->message = $message;
    }

    public function build()
    {
        return $this->view('mail.hajj_success')
            ->with([
                'code' => $this->code,
                'message' => $this->message,
            ]);
    }
} 