<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\PaymentOrder;

class AirBookingSuccess extends Mailable
{
    use Queueable, SerializesModels;

    public $paymentId;
    public $booking; // decoded booking_result array
    public $total;   // totals from updatedJsonData (response_json)

    public function __construct($paymentId)
    {
        $this->paymentId = $paymentId;
    }

    public function build()
    {
        $payment = PaymentOrder::find($this->paymentId);

        $this->booking = null;
        $this->total = null;

        if ($payment) {
            // booking_result holds the provider booking response (includes PNR, Itinerary, Passenger, etc.)
            $this->booking = $payment->booking_result ? json_decode($payment->booking_result, true) : null;
            // response_json holds the original updatedJsonData we sent to payment (includes total array)
            $requestPayload = $payment->response_json ? json_decode($payment->response_json, true) : null;
            if (is_array($requestPayload) && isset($requestPayload['total'])) {
                $this->total = $requestPayload['total'];
            }
        }

        return $this->view('mail.air_booking_success')
            ->with([
                'booking' => $this->booking,
                'total' => $this->total,
            ]);
    }



}
