<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AirBooking extends Mailable
{
    use Queueable, SerializesModels;

    public $booking; // decoded booking_result array
    public $total;   // totals from updatedJsonData (response_json)

    public function __construct($booking, $total)
    {
        $this->booking = json_decode($booking, true)??null;
        $this->total = $total;
    }

    public function build()
    {

        return $this->view('mail.air_booking_success')
            ->with([
                'booking' => $this->booking,
                'total' => $this->total,
            ]);
    }

}
