<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TBOPreBookResources extends JsonResource
{

    protected $companyName;

    public function __construct($resource, $companyName)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
    }

    public function toArray($request)
    {
        $total = $this->total();
        return [
            'company_name' => $this->companyName,
            'hotel_code' => $this['HotelCode'],
            'currency' => $this['Currency'],
            'name_room' => $this['Rooms'][0]['Name'],
            'bookingCode' => $this['Rooms'][0]['BookingCode'],
            'inclusion' => $this['Rooms'][0]['Inclusion'],
            'dayRates' => $this['Rooms'][0]['DayRates'],
            'totalFare' => $total['total_fare_tbo'],
           // 'totalFare' => $total['final_price'],
           // 'totalTax' => $this['Rooms'][0]['TotalTax'],
            'totalTax' => $total['tax'],
            'total_final' => $total['final_price'],
            'netPrice' => $total['base_price'],
            'cancelPolicies' => $this['Rooms'][0]['CancelPolicies'],
            'mealType' => $this['Rooms'][0]['MealType'],
            'isRefundable' => $this['Rooms'][0]['IsRefundable'],
            'withTransfers' => $this['Rooms'][0]['WithTransfers'],
            'amenities' => $this['Rooms'][0]['Amenities'] ?? [],
            'rateConditions' => $this['RateConditions'] ?? null,
            'total' => $total,
            'all_data' => $this->resource
        ];
    }

    private function total()
    {
        $total = $this['Rooms'][0]['RecommendedSellingRate'] ?? $this['Rooms'][0]['TotalFare'];
        $tax = $this['Rooms'][0]['TotalTax'];
        $netPrice = $total - $tax;
        $profit = $netPrice * 0.5;
        // السعر بعد الربح
        $priceWithProfit = $netPrice + $profit;
        // عمولة 2.25%
        $paymentFee = $priceWithProfit * 0.0225;
// السعر النهائي
        $finalPrice = $priceWithProfit + $paymentFee +$tax;

        return [
            'base_price' => round($netPrice, 2),
            'profit_10_percent' => round($profit, 2),
            'payment_fee_2_25' => round($paymentFee, 2),
            'final_price' => round($finalPrice, 2),
            'tax' => round($tax + $profit + $profit, 2),
            'total_fare_tbo' => round($total, 2),
            'tbo_tax' => round($tax, 2),
        ];
    }
}
