<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class HajjResource extends JsonResource
{
    private bool $withDetails = false;

    public function withDetails(bool $flag): static
    {
        $this->withDetails = $flag;
        return $this;
    }
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'code'=>$this->code,
            'status'=>$this->status,
            'name'=>$this->getFirstFullName(),
            'type'=>$this->type,
            "national"=>$this->getnationality->nationality_en ?? $this->getnationality->nationality_ar ?? null,
            "country_name"=>$this->getnationality->name_en ?? $this->getnationality->name_ar ?? null,
            "destination_name"=>$this->getVisaType->name_en ?? $this->getVisaType->name_ar ?? null,
            "destination_id"=>$this->country_id,
            "city_name"=>$this->getCitiy->name_en ?? $this->getCitiy->name_ar ?? null,
            'phone'=>$this->phone,
            'email'=>$this->email,
            'total'=>$this->total,
            'address'=>$this->address,
            'stat'=>$this->stat,
            "count_adult"=>$this->countByType('adult'),
            "count_child"=>$this->countByType('child'),
            'travel_date'=>$this->getDate(),
            'date_exp'=>$this->date_exp,
            'created_at'=>$this->created_at->format('Y-m-d'),
            'passport_details' => $this->when(
                $this->withDetails && $this->relationLoaded('passportDetails'),
                fn() => HajjPassportDetailsResource::collection($this->passportDetails)
            ),
        ];
    }

    private function getDate(){
        $date = Carbon::createFromDate(
            $this->year,
            $this->month,
            $this->day,
        );
        return $date->format('Y-m-d');
    }
    private function getFirstFullName()
    {
        if (!$this->relationLoaded('passportDetails') || $this->passportDetails->isEmpty()) {
            return null;
        }

        $first = $this->passportDetails->first();

        if (!$first) {
            return null;
        }
        return implode(' ', array_filter([
            $first->first,
            $first->second,
            $first->third,
            $first->last,
        ]));
    }
    private function countByType($type)
    {
        if (!$this->relationLoaded('passportDetails')) {
            return 0;
        }

        return $this->passportDetails->where('personality_type', $type)->count();
    }
}
