<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AirReservationResources extends JsonResource
{

    public function toArray($request)
    {

        $rueslt = json_decode($this->result,true);
        $search = json_decode($this->search,true);
        $flight= null;
        $details = null ;
        foreach ($search as $item)
        {

            if (isset($item['flight'])) {
                $flight = $item['flight'];
            }
            if(isset($item['details']))
            {
                $details = $item['details'];
            }
        }

        return [
            'company' => $this->company,
            'PNR'=>$this->pnr ?? $rueslt['PNR'],
            'origin'=> $rueslt['Itinerary']['Origin']??null,
            'destination'=> $rueslt['Itinerary']['Destination']??null,
            'TravelDate'=>$rueslt['Itinerary']['TravelDate']??null,
            'token_id'=>$this->token_id ?? $rueslt['TokenId']??null,
            'flight'=>$flight,
            'details'=>$details

        ];
    }

    function parseDuration($duration) {
        $parts = explode(':', $duration);
        return ($parts[0] * 60) + $parts[1] + ($parts[2] / 60);
    }

    function formatDuration($totalMinutes) {
        $hours = floor($totalMinutes / 60);
        $minutes = $totalMinutes % 60;
        $hoursText = $hours == 1 ? "$hours hr" : "$hours hrs";
        $minutesText = $minutes == 1 ? "$minutes min" : "$minutes mins";

        if ($hours > 0 && $minutes > 0) {
            return "$hoursText $minutesText";
        } elseif ($hours > 0) {
            return $hoursText;
        } else {
            return $minutesText;
        }
    }

    function getSegments($segments)
    {
        $flightDuration= [];
        $flightDetials =[];

        foreach ($segments as $segmentGroup) {
            $totalMinutes = 0;
            $airLineName = [];
            $airCode = [];
            $capenClass =[];
            $cabinBaggage =[];
            $includedBaggage =[];
            $cityName='';
            $destinationCityName='';


            foreach ($segmentGroup as $index =>$segment) {
                $timeDuration =0;
                if ($index === 0) {
                    $origin = $segment['Origin']['AirportCode'];
                    $depart = $segment['DepartureTime'];
                    $cityName = $segment['Origin']['CityName'];
                }
                $airLineName []=$segment['AirlineDetails']['AirlineName'];
                $cabinBaggage[]=$segment['CabinBaggage'] ?? '';
                $includedBaggage[]=$segment['IncludedBaggage'] ?? '';
                $key=$segment['AirlineDetails']['AirlineCode'] . '-'.$segment['AirlineDetails']['FlightNumber'];
                if(!isset($airCode[$key]))
                {
                    $airCode[$key] =[
                        'AirlineCode'=>$segment['AirlineDetails']['AirlineCode'],
                        'FlightNumber'=>$segment['AirlineDetails']['FlightNumber']
                    ];
                }
                $totalMinutes += $this->parseDuration($segment['Duration']);
                $totalMinutes += $this->parseDuration($segment['GroundTime']);
                $timeDuration += $this->parseDuration($segment['Duration']);
                $timeDuration += $this->parseDuration($segment['GroundTime']);

                if ($index === count($segmentGroup) - 1) {
                    $destination = $segment['Destination']['AirportCode'];
                    $destinationCityName = $segment['Destination']['CityName'];
                    $arrival = $segment['ArrivalTime'];
                }
                $groundtime = $this->parseDuration($segment['GroundTime']);
                $flightDetials[]=[
                    'name'=>$segment['AirlineDetails']['AirlineName'],
                    'code'=>$segment['AirlineDetails']['AirlineCode'],
                    'craft'=>$segment['Craft'],
                    'groundTime'=>$this->formatDuration($groundtime),
                    'departure'=>[
                        'cityName'=>$segment['Origin']['CityName'],
                        'cityCode'=>$segment['Origin']['CityCode'],
                        'country'=>$segment['Origin']['CountryName'],
                        'countryCode'=>$segment['Origin']['CountryCode'],
                        'airportName'=>$segment['Origin']['AirportName'],
                        'airportCode'=>$segment['Origin']['AirportCode'],
                        'terminal'=>$segment['Origin']['Terminal'],
                        'DepartureTime'=>  \Carbon\Carbon::parse($segment['ArrivalTime'])->format('Y-m-d H:i:s'),
                        'DepartureTime_timestamp'=>  \Carbon\Carbon::parse($segment['ArrivalTime'])->timestamp,

                    ],
                    'arrival'=>[
                        'cityName'=>$segment['Destination']['CityName'],
                        'cityCode'=>$segment['Destination']['CityCode'],
                        'country'=>$segment['Destination']['CountryName'],
                        'countryCode'=>$segment['Destination']['CountryCode'],
                        'airportName'=>$segment['Destination']['AirportName'],
                        'airportCode'=>$segment['Destination']['AirportCode'],
                        'terminal'=>$segment['Destination']['Terminal'],
                        'arrivalTime'=> \Carbon\Carbon::parse($segment['DepartureTime'])->format('Y-m-d H:i:s'),
                        'arrivalTime_timestamp'=> \Carbon\Carbon::parse($segment['DepartureTime'])->timestamp,
                    ],
                    'flightDuration'=>$this->formatDuration($timeDuration),
                    'baggage'=>[
                        'cabin'=>$segment['IncludedBaggage']?? '' ,
                        'checkIn'=>$segment['CabinBaggage'] ?? ''
                    ],

                ];

                if($segment['CabinClass']!=null && $segment['CabinClass']!= "")
                    $capenClass[]=$segment['CabinClass'];
            }

            $flightDuration['flight'][] = [
                'origin'=> $origin,
                'time'=>$this->formatDuration($totalMinutes),
                'destination'=> $destination,
                'cityNameOrigin'=>$cityName,
                'cityNameDestination'=>$destinationCityName,
                'arrival_timestamp'=> \Carbon\Carbon::parse($arrival)->timestamp,
                'arrival'=> \Carbon\Carbon::parse($arrival)->format('Y-m-d H:i:s'),
                'depart_timestamp'=> \Carbon\Carbon::parse($depart)->timestamp,
                'depart'=> \Carbon\Carbon::parse($depart)->format('Y-m-d H:i:s'),
                'airlineName'=> array_unique($airLineName),
                'airlineCode'=> array_values($airCode),
                'cabinClass'=> array_unique($capenClass),
                'cabinBaggage'=> array_unique($cabinBaggage),
                'includedBaggage'=> array_unique($includedBaggage)
            ];
            $flightDuration['details']= $flightDetials;
            //$flightDuration

        }

        return $flightDuration;
    }
}
