<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class AirReservationCollection extends ResourceCollection
{
    public function toArray($request)
    {
        return [
            'data' => AirReservationResources::collection($this->collection),
            'links' => $this->paginationLinks(),
            'meta' => [
                'pagination' => [
                    'total' => $this->total()??0,
                    'count' => $this->count()??0,
                    'per_page' => $this->perPage()??0,
                    'current_page' => $this->currentPage()??0,
                    'total_pages' => $this->lastPage()??0,
                    'next_page' => $this->currentPage() ? $this->currentPage() + 1 : 0,
                ],
            ],
        ];
    }


    protected function paginationLinks()
    {
        $paginator = $this->resource;


        $prevPage = $paginator->currentPage() - 1;
        $nextPage = $paginator->currentPage() + 1;


        $links =  $nextPage <= $paginator->lastPage() ? $paginator->url($nextPage) : 0;

        return $links;
    }
}
