<?php

namespace App\Http\Controllers\api;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\AirReservationCollection;
use App\Http\Resources\ReservationCollection;
use App\Models\AirReservation;
use App\Models\Reservation;
use Carbon\Carbon;


class UsersHistory extends Controller
{
    use ApiResponse;
     public function hotel($limit = 10,$type = "booth"){
        $id =  Auth()->guard('api')->user()->id;
        if($type == "booth")
        {
            $data = Reservation::where('user_id',$id)->orderBy('id','desc')->paginate($limit);
        }else{
            $op = $type == 'history' ? '<':'>=';
            $data = Reservation::where([
                ['user_id',$id],
                ['check_in',$op,Carbon::now()->format("Y-m-d")]
            ])->orderBy('id','desc')->paginate($limit);
        }
        $collect = new ReservationCollection($data);
        return $this->apiResponse(200, 'Hotel Data', null, $collect);
    }
    public function air($limit)
    {
        $id =  Auth()->guard('api')->user()->id;
        $data = AirReservation::where('user_id',$id)->orderBy('id','desc')->paginate($limit);
        $collect = new AirReservationCollection($data);
        return $this->apiResponse(200, 'Air Data', null, $collect);

    }
}
