<?php

namespace App\Http\Controllers\api;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\HotelResource;
use App\Models\Guest;
use App\Models\Hotel;
use App\Models\hotelDetials;
use App\Models\PaymentOrder;
use App\Models\User;
use App\sys\Services\Hotel\HotelServices;
use App\Sys\Services\PaymentService;
use App\TBO;
use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Mail\HotelBookingSuccess;
use function MongoDB\BSON\toJSON;
use function PHPUnit\Framework\isJson;
use Validator;

class HotelSearchController extends Controller
{
    use ApiResponse;
    use TBO;

    private $hotel;
    private $payment;

    public function __construct()
    {
        $this->hotel = new HotelServices();
        $this->payment = new PaymentService();
    }

    public function getCountry()
    {
        $country = $this->hotel->getCountry();
        return $this->apiResponse(200, 'Country data', null, $country);
    }

    public function getCity($code)
    {
        $city = $this->hotel->city($code);
        return $this->apiResponse(200, 'Country data', null, $city);
    }

    public function HotelByCity($code, $is_detailed = false)
    {
        $isDe = $is_detailed == false ? 'out DetailedResponse' : "DetailedResponse";
        $massage = 'hotel data with ' . $isDe;
        $hotel = $this->hotel->getHotelCodeByCity($code, $is_detailed, 'normal');
        return $this->apiResponse(200, $massage, null, $hotel);
    }

    public function search()
    {


        //return request()->all();
        $chiled = request()->children_ages != null ? array_map('intval', explode(',', request()->children_ages)) : [];
        $Adults = request()->adults != null ? array_map('intval', explode(',', request()->adults)) : [];
        $Children = request()->children != null ? array_map('intval', explode(',', request()->children)) : [];
        if (Auth()->guard('api')->check()) {
            $nationality = request()->country == 'AE' && Auth()->guard('api')->user()->residency == 'AE' ? 'AE' : Auth()->guard('api')->user()->nationality;
        } else {
            $nationality = request()->guestNationality;
        }
        $PaxRooms = [];

        $ageIndex = 0;

        for ($i = 0; $i < count($Adults); $i++) {
            $numChildren = isset($Children[$i]) ? (int)$Children[$i] : 0;
            $room = [
                "Adults" => (int)$Adults[$i],
                "Children" => $numChildren,
                "ChildrenAges" => array_slice($chiled, $ageIndex, $numChildren)
            ];

            $ageIndex += $numChildren;

            $PaxRooms[] = $room;
        }
        //return request()->all();
        /*
          $paxRooms = [
              [
                  'Adults' => (int)request()->adults,
                  'Children' => (int)request()->children,
                  'ChildrenAges' =>$chiled
              ]
          ];*/
        $filter = [
            'Refundable' => (string)request()->refundable,
            'NoOfRooms' => 0,
            'MealType' => (string)request()->meal_type,
        ];
        $pramter = [
            "CheckIn" => request()->check_in,
            "CheckOut" => request()->check_out,
            "GuestNationality" => $nationality,
            "PaxRooms" => $PaxRooms,
            "Filters" => $filter,
            "IsDetailedResponse" => true,
            "ResponseTime" => 5.0,
            "Currency" => request()->has('Currency') ? request()->Currency : "AED",
            "MinPrice" => 0,
            "MaxPrice" => 30,
            "cases" => request()->has('cases') ? request()->cases : request()->attributes->get('guest_id')

        ];

        if (request()->has('hotel') && request()->hotel != null) {
            //get room
            $pramter["HotelCodes"] = request()->hotel;
            if ($rooms = $this->hotel->SearchRoom($pramter))
                return $this->apiResponse(200, 'data rooms', null, $rooms);


            $errors = $this->hotel->errors();
            $check = $errors['Description'] ?? $errors ?? null;
            return $this->apiResponse(201, 'data Hotel', $check, null);
        } else {
            if ($hotel = $this->hotel->SearchHotel($pramter))
                return $this->apiResponse(200, 'data Hotel', null, $hotel);


            $errors = $this->hotel->errors();
            $check = $errors['Description'] ?? $errors[0] ?? 'have Errors';
            return $this->apiResponse(201, 'data Hotel', $check, null);
        }
    }


    public function prebook(Request $request)
    {
        $pramter = [
            'BookingCode' => $request->get('booking_code'),
            'PaymentMode' => $request->get('payment'),
        ];

        if ($hotel = $this->hotel->getPerBook($pramter, $request->company_name)) {
            return $this->apiResponse(200, 'data Rooms', null, $hotel);
        }
        $errors = $this->hotel->errors();
        $check = $errors['Description'] ?? $errors ?? null;
        return $this->apiResponse(201, 'data Hotel', $check, null);
    }

    public function bookingBTO(Request $request)
    {
        $id = request()->attributes->get('guest_id');
        $jsonContent = $request->getContent();
        if (empty($jsonContent))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);


        $updatedJsonData = json_decode($jsonContent);

        if ($this->hasDuplicateFirstNames($updatedJsonData->CustomerDetails)) {
            return $this->apiResponse(201, 'Errors', 'Duplicate first names are not allowed in the booking', null);
        }


        if (Auth()->guard('api')->check()) {
            $nationality = $updatedJsonData->country == 'AE' && Auth()->guard('api')->user()->residency == 'AE' ? 'AE' : Auth()->guard('api')->user()->nationality;
        } else {
            $nationality = $updatedJsonData->guestNationality;
        }


        $updatedJsonData->ClientReferenceId = uniqid() . time() . Str::random(5);
        $updatedJsonData->BookingReferenceId = uniqid() . Str::random(2);
        $updatedJsonData->GuestNationality = $nationality;

        if (isset($updatedJsonData->payment_type) && $updatedJsonData->payment_type == 'wallet') {
            // check wallet
            if (!Auth()->guard('api')->check()) {
                return $this->apiResponse(201, 'Not Authentication', ['Not Authentication'], null);
            }

            if (Auth()->guard('api')->user()->wallet >= round((double)$updatedJsonData->total->final_price, 2)) {
                $guestData = ['guest' => $id, 'id' => Auth()->guard('api')->user()->id];
                if ($this->hotel->tboBooking($updatedJsonData, ['id' => null], $guestData)) {
                    $data = $this->hotel->getData();
                    $send = [
                        'client_referenceId' => $data['ClientReferenceId'],
                        'confirmation_number' => $data['ConfirmationNumber'],
                        'company' => 'tbo'
                    ];

                    if (Auth()->guard('api')->user()->client_email != null) {
                        Mail::to(Auth()->guard('api')->user()->client_email)->send(new HotelBookingSuccess(
                            $data['ConfirmationNumber'],
                            $id,
                            Auth()->guard('api')->user()->id,
                            $data['reservation']
                        ));
                    }
                    return $this->apiResponse(200, $data['Status']['Description'], null, $send);
                }
                $errors = $this->hotel->errors();
                $check = $errors['Description'] ?? $errors ?? null;
                return $this->apiResponse(201, 'data Hotel', $check, null);

            }
            return $this->apiResponse(201, 'Errors', ['The wallet does not contain the required amount.'], null);
        }


        if (!isset($updatedJsonData->TotalFare) && !isset($updatedJsonData->currency)) {
            return $this->apiResponse(201, 'Errors', 'plases set currency Or TotalFare', null);
        }

        $gues = Guest::find($id);
        $expiredTime = Carbon::parse($gues->hotel_time);
        //$remainingMinutes = (int)$expiredTime->diff(Carbon::now())->format('%I');
        $remainingMinutes = (int)$expiredTime->greaterThan(Carbon::now())
            ? $expiredTime->diff(Carbon::now())->format('%I')
            : '0';

        if ($remainingMinutes < 3) {
            return $this->apiResponse(408, 'Session Time expired', ['Session Time expired'], null);
        }

        $data = [
            "type" => "hotel",
            "action" => "SALE",
            "currency_code" => "AED",
            "value" => intval((int)$updatedJsonData->total->final_price * 100)
        ];
        // get web view
        if ($payment = $this->payment->getWebview($data, $updatedJsonData)) {
            $url = route('payment-webview', ['payment_code' => $payment->id, 'user_id' => $payment->user_id]);
            $checkStatus = route('checkingBooking', ['id' => $payment->id]);
            $data = [
                "url" => $url,
                "payment_code" => $payment->id,
                'check_status_url' => $checkStatus,
                'pramater_one' => $payment->id,
                'pramater_two' => $payment->user_id,
            ];
            return $this->apiResponse(200, 'payment', null, $data);
        }
        return $this->apiResponse(201, 'payment', ['Sorry Try again'], null);

    }

    public function PaymentStatus(Request $request)
    {

        $content = $request->getContent();
        $json = json_decode($content);
        $data = [
            'activity_status' => "paid",
            'payment_status' => $json->activity_status,
            'id' => $json->payment_code
        ];
        $payment = PaymentOrder::find($json->payment_code);
        if (!empty($payment)) {
            $user = User::find($payment->user_id);
            $paData = $payment->pay_response != null ? json_decode($payment->pay_response, true) : null;
            $respo = $this->payment->checkStatus($json->payment_code, $paData);
            $status = isset($respo['_embedded']['payment'][0]['state']) ? $respo['_embedded']['payment'][0]['state'] : $payment->payment_status;
            if ($status == "CAPTURED") {
                $updatedJsonData = json_decode($payment->response_json, true);
                if ($this->hotel->tboBooking($updatedJsonData, $data, ['id' => $payment->user_id, 'guest' => $payment->guest_id])) {
                    $reservation = $this->hotel->getData();
                    $payment->reservation_id = $reservation['reservation'];
                    $payment->activity_status = 'BOOKING';
                    $payment->booking_result = json_encode($reservation);
                    $payment->payment_status = "CAPTURED";
                    $payment->order_id = $respo["reference"];
                    $payment->save();

                    // Queue success email with booking details fetching inside mailable

                    if ($user && $user->client_email) {
                        Mail::to($user->client_email)->send(new HotelBookingSuccess(
                            $reservation['ConfirmationNumber'],
                            $payment->guest_id,
                            $payment->user_id,
                            $payment->reservation_id
                        ));
                    }

                    return response(
                        ['status' => 200,
                            'message' => 'check status',
                            'payment_status' => $json->activity_status],
                        200
                    );
                } else {

                    $user->wallet = $payment->value / 100;
                    $user->save();
                    $errors = $this->hotel->errors();
                    $payment->activity_status = 'FAILURE';
                    $payment->booking_result = json_encode($errors);
                    $payment->payment_status = "REFUNDED";
                    $payment->order_id = $respo["reference"];
                    $payment->done_refund = 1;
                    $payment->save();
                    return response(
                        ['status' => 200,
                            'message' => 'check status',
                            'payment_status' => "FAILURE"],
                        200
                    );

                }
            }
            $payment->payment_status = $status;
            $payment->save();
            return response(
                ['status' => 200,
                    'message' => 'check status',
                    'payment_status' => "FAILURE"],
                200
            );
        }
        return response(
            ['status' => 404,
                'message' => 'check status',
                'errors' => 'payment order not found'],
            404
        );
    }

    public
    function bookingDetail(Request $request)
    {
        $req = Validator::make($request->all(), [
            'company' => 'required',
            // 'booking_referenceId' => 'required_if:confirmation_number,!=,null',
            'confirmation_number' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }

        $re = $request->booking_referenceId ?? null;

        if ($hotel = $this->hotel->bookingDetails($request->confirmation_number, $request->company, $re)) {
            return $this->apiResponse(200, $hotel['Status']['Description'], null, $hotel['BookingDetail']);
        }

        $errors = $this->hotel->errors();
        return $this->apiResponse(201, 'Errors', $errors['Status']['Description'] ?? $errors[0] ?? 'have Errors', null);

    }

    public
    function cancel(Request $request)
    {

        $req = Validator::make($request->all(), [
            'confirmation_number' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }
        $data['ConfirmationNumber'] = $request->confirmation_number;
        if ($this->hotel->cancel($data, 'tbo')) {
            $resl = $this->hotel->getData();
            return $this->apiResponse(200, $resl['Status']['Description'], null, $resl['ConfirmationNumber']);
        }
        $errors = $this->hotel->errors();
        $check = $errors['Description'] ?? $errors ?? null;
        return $this->apiResponse(201, 'data Hotel', $check, null);
    }

    public
    function hotelDetails(Request $request)
    {

        $req = Validator::make($request->all(), [
            'Hotelcodes' => 'required',
        ]);

        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }

        $hotelData = hotelDetials::where([['company_name', 'tbo'], ['code', $request->Hotelcodes]])->first();
        if (!empty($hotelData)) {
            $a[] = json_decode($hotelData->properties);
            return $this->apiResponse(200, 'data Hotel', null, $a);
        }
        if ($hotel = $this->hotel->getHotelDetails($request->all())) {

            if (!empty($hotel)) {
                $newHotel = new hotelDetials();
                $newHotel->company_name = 'tbo';
                $newHotel->code = $hotel[0]['HotelCode'];
                $newHotel->hotel_name = $hotel[0]['HotelName'];
                $newHotel->properties = json_encode($hotel[0]);
                $newHotel->last_updated = date('Y-m-d');
                $newHotel->save();
            }
            return $this->apiResponse(200, 'data Hotel', null, $hotel);
        }


        $errors = $this->hotel->errors();
        //dd($errors);
        //return $this->apiResponse(201, 'Errors', $errors['Description'], null);
        $check = $errors['Description'] ?? $errors ?? null;
        return $this->apiResponse(201, 'data Hotel', $check, null);
    }

    public
    function test()
    {
        $client = new Client();
        $response = $client->get('TBO_STAGING_API_SERVICE_URL', [
            'auth' => [env('TBO_STAGING_API_USERNAME'), env('TBO_STAGING_API_PASSWORD')],
            'query' => ['cityName' => 'cairo'],
        ]);

        $cityData = json_decode($response->getBody(), true);
        // Extract city code from the response
        $cityCode = $cityData['CityList'][0]['CityCode'] ?? null;

        return $cityCode;
    }

    public
    function hasDuplicateFirstNames($customerDetails)
    {

        $firstNames = [];

        foreach ($customerDetails as $customer) {
            if (isset($customer->CustomerNames) && is_array($customer->CustomerNames)) {
                foreach ($customer->CustomerNames as $customerName) {
                    $firstName = $customerName->FirstName ?? ''; // الوصول باستخدام ->
                    if (in_array($firstName, $firstNames)) {
                        return true; // Duplicate found
                    }
                    $firstNames[] = $firstName;
                }
            }
        }

        return false;
    }

    public
    function checkingBooking($id)
    {
        $payment = $this->payment->findHotel($id);
        if (!empty($payment)) {
            if ($payment->pay_response != null) {

                $client_referenceId = null;
                $confirmation_number = null;
                $company = null;
                $notes = null;
                if ($payment->payment_status != "PENDING REFUNDED") {
                    $de = json_decode($payment->pay_response, true);
                    $respo = $this->payment->checkStatus($id, $de);
                    if ($payment->hotel != null) {
                        $client_referenceId = $payment->hotel->client_referenceId;
                        $confirmation_number = $payment->hotel->confirmation_number;
                        $company = $payment->hotel->company;
                    }
                    $status = isset($respo['_embedded']['payment'][0]['state']) ? $respo['_embedded']['payment'][0]['state'] : $payment->payment_status;
                    if ($status == "CAPTURED" && $payment->activity_status == "BOOKING") {
                        $notes = "Booking and payment completed successfully";
                    } elseif ($status == "REFUNDED" && $payment->activity_status == "FAILURE") {
                        $notes = "Payment was refunded again due to failed booking";
                    } else {
                        $notes = "Payment and booking process failed";
                    }
                } else {
                    $status = $payment->payment_status;
                    $notes = "The booking has failed, and the refund process is underway. Please wait, or contact customer support for assistance";
                }

                if ($client_referenceId == null && $confirmation_number == null) {
                    $booking_details = null;
                } else {
                    $booking_details = [
                        "client_referenceId" => $client_referenceId,
                        "confirmation_number" => $confirmation_number,
                        'company' => $company,
                    ];
                }
                $data = [
                    'payment_status' => $status,
                    'booking_status' => $payment->activity_status,
                    "booking_details" => $booking_details,
                    "note" => $notes
                ];
                return $this->apiResponse(200, 'OrderStatus', null, $data);
            } else {
                if ($payment->isExpired()) {
                    $data = [
                        'payment_status' => 'EXPIRED',
                        'booking_status' => $payment->activity_status,
                        "booking_details" => null,
                        "note" => "session payment time expired"
                    ];
                    return $this->apiResponse(408, 'OrderStatus', null, $data);
                }

                $data = [
                    'payment_status' => $payment->payment_status,
                    'booking_status' => $payment->activity_status,
                    "booking_details" => null,
                    "note" => ""
                ];
                return $this->apiResponse(200, 'OrderStatus', null, $data);

            }

        }
        return $this->apiResponse(201, 'Errors', ['Not Found'], null);
    }
}
