<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\ApiResponse;
use App\Mail\ContactUs;
use App\Sys\Services;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Support\Facades\Mail;

class ContactUsApiControllers extends Controller
{

    use ApiResponse;
    private $ser;

    public function __construct()
    {
        $this->ser = new Services();
    }

    public function Contact(Request $request)
    {
        $data = $request->all();
        $rules = [
            'name' => 'required',
            'title' => 'required',
            'email' => 'required|email',
            'message' => 'required',
        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->ser->setError($validator->errors());
            $errors = $this->ser->errors();
            return $this->apiResponse(201, 'Have Errors',$errors, null);
        }


        Mail::to('ec4e526bf7-50d353@inbox.mailtrap.io')->send(new ContactUs($data));

        if (Mail::flushMacros()) {
            return $this->apiResponse(201, 'Errors Send',['send Errors'], null);
        }

        return $this->apiResponse(200, ' Send Success',null, null);

    }
}
