<?php

namespace App\Http\Controllers\api\Air;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Models\Guest;
use App\Models\PaymentOrder;
use App\Sys\Services\Air\AirServices;
use App\Sys\Services\PaymentService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Validator;

class AirControllers extends Controller
{
    use ApiResponse;

    public $airSer;
    private $payment;

    public function __construct()
    {
        $this->airSer = new AirServices();
        $this->payment = new PaymentService();
    }

    public function search(Request $request)
    {

        $jsonContent = $request->getContent();
        $updatedJsonData = json_decode($jsonContent);
        if (empty($updatedJsonData))
            return $this->apiResponse(400, 'Bad Request', ['json' => 'JSON content is empty'], null);


        $ru = (array)$updatedJsonData;
        if (isset($ru['Segment']) && is_array($ru['Segment'])) {
            $ru['Segment'] = array_map(function ($ru) {
                return (array)$ru;
            }, $ru['Segment']);
        }
        if ($data = $this->airSer->search($ru))
            return $this->apiResponse(200, 'Search Success', null, $data);


        $errors = $this->airSer->errors();
        if (empty($errors))
            return $this->apiResponse(200, 'Search Success', null, []);


        return $this->apiResponse(201, 'error', $errors, null);
    }

    public function searchDetials(Request $request)
    {

        $jsonContent = $request->getContent();
        $updatedJsonData = json_decode($jsonContent);
        if (empty($updatedJsonData))
            return $this->apiResponse(201, 'Bad Request', ['json' => 'JSON content is empty'], null);


        if ($updatedJsonData->company_name == "tbo") {
            if ($data = $this->airSer->searchDetailsTBO($updatedJsonData))
                return $this->apiResponse(200, 'search detials Success', null, $data);

            $errors = $this->airSer->errors();
            return $this->apiResponse(201, 'error', $errors, null);
        }

        return $this->apiResponse(201, 'error', ['company_name' => 'Not Found Company'], null);
    }

    public function booking(Request $request)
    {
        $jsonContent = $request->getContent();
        $updatedJsonData = json_decode($jsonContent);
        if (empty($updatedJsonData))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);


        if ($updatedJsonData->company_name == "tbo") {

            if ($updatedJsonData->Itinerary->IsLcc == false) {

                if ($data = $this->airSer->bookingNoncLcc($updatedJsonData))
                    return $this->apiResponse(200, 'Search Success', null, $data);


                $errors = $this->airSer->errors();
                return $this->apiResponse(201, 'error', $errors, null);
            }
            return $this->apiResponse(201, 'error', 'Go To Ticket', null);
        }
    }

    public function ticketLcc(Request $request)
    {

        $id = request()->attributes->get('guest_id');

        $jsonContent = $request->getContent();
        $updatedJsonData = json_decode($jsonContent);
        if (empty($updatedJsonData))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);

        if ($updatedJsonData->company_name == "tbo") {
            if ($updatedJsonData->Itinerary->IsLcc == false && $updatedJsonData->PNR == null) {
                return $this->apiResponse(201, 'error', ['PNR' => 'is required value , if not have PNR Got to Booking first'], null);
            }

            // payments
            if (isset($updatedJsonData->payment_type) && $updatedJsonData->payment_type == 'wallet') {
                // check wallet
                if (!Auth()->guard('api')->check()) {
                    return $this->apiResponse(201, 'Not Authentication', ['Not Authentication'], null);
                }

                if(Auth()->guard('api')->user()->wallet  >= round((double)$updatedJsonData->TotalFare, 2)){

                    if($data = $this->airSer->ticketForLcc($updatedJsonData, ['id'=>null], ['id' => Auth()->guard('api')->user()->id, 'guest' => $id])) {
                        $rueslt = [
                            'pnr' => $data['PNR'],
                            'token_id' => $data['TokenId'],
                            'company' => $updatedJsonData->company_name,
                        ];
                        return $this->apiResponse(200, 'Booking', null, $rueslt);
                    }
                    $errors = $this->airSer->errors();
                    return $this->apiResponse(201, 'error', $errors, null);
                }

                return $this->apiResponse(201, 'Errors', ['The wallet does not contain the required amount.'], null);

            }


            $gues = Guest::find($id);
            $expiredTime = Carbon::parse($gues->air_time);
            $remainingMinutes = (int)$expiredTime->diff(Carbon::now())->format('%I');

            if ($remainingMinutes < 3) {
                return $this->apiResponse(408, 'Session Time expired', ['Session Time expired'], null);
            }

            $data = [
                "type" => "air",
                "action" => "SALE",
                "currency_code" => $updatedJsonData->currency,
                "value" => intval($updatedJsonData->TotalFare * 100)
            ];
            // get web view
            if ($payment = $this->payment->getWebview($data, $updatedJsonData)) {
                $url = route('payment-webview', ['payment_code' => $payment->id, 'user_id' => $payment->user_id]);
                $checkStatus = route('checkingBookingAir', ['id' => $payment->id]);
                $data = [
                    "url" => $url,
                    "payment_code" => $payment->id,
                    'check_status_url' => $checkStatus,
                    'pramater_one' => $payment->id,
                    'pramater_two' => $payment->user_id,
                ];
                return $this->apiResponse(200, 'payment', null, $data);
            }
            return $this->apiResponse(201, 'payment', ['Sorry Try again'], null);

        }

        return $this->apiResponse(201, 'error', ['company_name' => 'is required  and value is true'], null);


    }

    public function GetBookingDetails(Request $request)
    {

        $req = Validator::make($request->all(), [
            'pnr' => 'required',
            'token_id' => 'required',
            'company_name' => 'required',

        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }

        if ($request->company_name == "tbo") {
            if ($data = $this->airSer->getBookingDetalis($request->all())) {
                return $this->apiResponse(200, 'GEt Booking Detalis', null, $data);
            }

            $errors = $this->airSer->errors();
            return $this->apiResponse(201, 'error', $errors, null);
        }

        $this->airSer->setError(['company_name' => "not tbo"]);
        $errors = $this->airSer->errors();
        return $this->apiResponse(201, 'error', $errors, null);

    }

    public function PaymentStatus(Request $request)
    {
        $content = $request->getContent();
        $json = json_decode($content);
        $pamynetCheck = [
            'activity_status' => "paid",
            'payment_status' => $json->activity_status,
            'id' => $json->payment_code
        ];
        $payment = PaymentOrder::find($json->payment_code);
        if (!empty($payment)) {
            $paData = $payment->pay_response != null ? json_decode($payment->pay_response, true) : null;
            $respo = $this->payment->checkStatus($json->payment_code, $paData);
            $status = isset($respo['_embedded']['payment'][0]['state']) ? $respo['_embedded']['payment'][0]['state'] : $payment->payment_status;
            // check payment
            if ($status == "CAPTURED") {
                $updatedJsonData = json_decode($payment->response_json, true);
                if ($data = $this->airSer->ticketForLcc($updatedJsonData, $pamynetCheck, ['id' => $payment->user_id, 'guest' => $payment->guest_id])) {
                    $payment->activity_status = 'BOOKING';
                    $payment->booking_result = json_encode($data);
                    $payment->payment_status = "CAPTURED";
                    $payment->save();
                    return response(
                        ['status' => 200,
                            'message' => 'check status',
                            'payment_status' => $json->activity_status],
                        200
                    );
                } else {
                    $link = $respo['_embedded']['payment'][0]['_embedded']['cnp:capture'][0]['_links']['cnp:refund']['href'] ?? null;
                    // make refund
                    $url = $this->payment->extractRefundLink($link);
                    $params = [
                        "amount" => [
                            "currencyCode" => $payment->currency_code,
                            "value" => $payment->value
                        ]
                    ];
                    $ref = $this->payment->refund($url, $params);
                    $errors = $this->airSer->errors();
                    $payment->activity_status = 'FAILURE';
                    $payment->booking_result = json_encode($errors);
                    $payment->payment_status = "REFUNDED";
                    $payment->save();
                    return response(
                        ['status' => 200,
                            'message' => 'check status',
                            'payment_status' => "FAILURE"],
                        200
                    );
                }

            }

            $payment->payment_status = $status;
            $payment->save();
            return response(
                ['status' => 200,
                    'message' => 'check status',
                    'payment_status' => "FAILURE"],
                200
            );
        }
        return response(
            [
                'status' => 404,
                'message' => 'check status',
                'errors' => 'payment order not found'
            ],
            404
        );
    }

    public function checkingBooking($id)
    {
        $payment = $this->payment->findHotel($id);
        if (!empty($payment)) {
            if ($payment->pay_response != null) {
                $respo = $this->payment->checkStatus($id, $payment->pay_response);
                $pnr = null;
                $token_id = null;
                $company = null;
                $notes = null;
                if ($payment->air != null) {
                    //$detilas = json_decode($payment->air->result, true);
                    $pnr = $payment->air->pnr;
                    $token_id = $payment->air->token_id;
                    $company = $payment->air->company;

                }
                $status = isset($respo['_embedded']['payment'][0]['state']) ? $respo['_embedded']['payment'][0]['state'] : $payment->payment_status;
                if ($status == "CAPTURED" && $payment->activity_status == "BOOKING") {
                    $notes = "Booking and payment completed successfully";
                } elseif ($status == "REFUNDED" && $payment->activity_status == "FAILURE") {
                    $notes = "Payment was refunded again due to failed booking";
                } else {
                    $notes = "Payment and booking process failed";
                }
                $data = [
                    'payment_status' => $status,
                    'booking_status' => $payment->activity_status,
                    "booking_detials" => [
                        'pnr' => $pnr,
                        'token_id' => $token_id,
                        'company' => $company,
                    ],
                    "note" => $notes
                ];
                return $this->apiResponse(200, 'OrderStatus', null, $data);
            } else {
                if ($payment->isExpired()) {
                    $data = [
                        'payment_status' => 'EXPIRED',
                        'booking_status' => $payment->activity_status,
                        "booking_details" => null,
                        "note" => "session payment time expired"
                    ];
                    return $this->apiResponse(408, 'OrderStatus', null, $data);
                }

                $data = [
                    'payment_status' => $payment->payment_status,
                    'booking_status' => $payment->activity_status,
                    "booking_details" => null,
                    "note" => ""
                ];
                return $this->apiResponse(200, 'OrderStatus', null, $data);

            }
        }
        return $this->apiResponse(201, 'Errors', ['Not Found'], null);
    }
}


